/***************************************************************************
                            KDoubleNumInput.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KDoubleNumInput combines a {@link QSpinBox} and optionally a {@link QSlider}
 with a label to make an easy to use control for setting some float
 parameter. This is especially nice for configuration dialogs,
 which can have many such combinated controls.

 The slider is created only when the user specifies a range
 for the control using the setRange function with the slider
 parameter set to "true".

 A special feature of KDoubleNumInput, designed specifically for
 the situation when there are several KDoubleNumInputs in a column,
 is that you can specify what portion of the control is taken by the
 QSpinBox (the remaining portion is used by the slider). This makes
 it very simple to have all the sliders in a column be the same size.

 It uses KDoubleValidator validator class. KDoubleNumInput enforces the
 value to be in the given range.

 @short An input control for real numbers, consisting of a spinbox and a slider.
 
*/
public class KDoubleNumInput extends KNumInput  {
	protected KDoubleNumInput(Class dummy){super((Class) null);}


/** 
 Constructs an input control for double values
 with initial value 0.0.
     
*/
	private native void newKDoubleNumInput( QWidget parent, String name);
	public KDoubleNumInput( QWidget parent, String name) {
		super((Class) null);
		newKDoubleNumInput( parent, name);
	}
	private native void newKDoubleNumInput();
	public KDoubleNumInput() {
		super((Class) null);
		newKDoubleNumInput();
	}

/** 
 Constructor

*/
	private native void newKDoubleNumInput( double value, QWidget parent, String name);
	public KDoubleNumInput( double value, QWidget parent, String name) {
		super((Class) null);
		newKDoubleNumInput( value, parent, name);
	}
	private native void newKDoubleNumInput( double value);
	public KDoubleNumInput( double value) {
		super((Class) null);
		newKDoubleNumInput( value);
	}

/** 
 destructor
     
*/
	protected native void finalize() throws InternalError;

/** 
 Constructor

 put it below other KNumInput

*/
	private native void newKDoubleNumInput( KNumInput below, double value, QWidget parent, String name);
	public KDoubleNumInput( KNumInput below, double value, QWidget parent, String name) {
		super((Class) null);
		newKDoubleNumInput( below, value, parent, name);
	}
	private native void newKDoubleNumInput( KNumInput below, double value);
	public KDoubleNumInput( KNumInput below, double value) {
		super((Class) null);
		newKDoubleNumInput( below, value);
	}

/** 

*/
	public native double value();

/** 

*/
	public native String suffix();

/** 

*/
	public native String prefix();

/** 

*/
	public native String format();

/** 

*/
	public native String specialValueText();

/** 

*/
	public native void setRange( double lower, double upper, double step, boolean slider);
	public native void setRange( double lower, double upper);

/** 
 Sets the format string that should be used to display the double value.
 The format string follows the same rules as the printf() function or
 {@link String#sprintf}. You can use this if you want to set the number
 of digits to be displayed, etc.
     
*/
	public native void setFormat( String format);

/** 
 Sets the special value text. If set, the spin box will display
 this text instead of the numeric value whenever the current
 value is equal to {@link #minVal}. Typically this is used for indicating
 that the choice has a special (default) meaning.
     
*/
	public native void setSpecialValueText( String text);

/** 
 Sets the value of the control.
     
*/
	public native void setValue( double arg1);

/** 
 Sets the suffix to be displayed to <code>suffix.</code> Use String.null to disable
 this feature. Note that the suffix is attached to the value without any
 spacing. So if you prefer to display a space separator, set suffix
 to something like " cm".

*/
	public native void setSuffix( String suffix);

/** 
 Sets the prefix to be displayed to <code>prefix.</code> Use String.null to disable
 this feature. Note that the prefix is attached to the value without any
 spacing.

*/
	public native void setPrefix( String prefix);
	protected native void resetEditBox();
}

/** Override these methods in subclasses of KDoubleNumInput to customise event handling behaviour */
interface KDoubleNumInputEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);

/** 

     
*/
	void resizeEvent(QResizeEvent arg1);
}

