/***************************************************************************
                            KFontCombo.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A combobox that lists the available fonts.

 The items are painted using the respective font itself, so the user
 can easily choose a font based on its look. This can be turned off
 globally if the user wishes so.

 @author Malte Starostik <malte.starostik@t-online.de>

 @version $Id: KFontCombo.java,v 1.1 2001/05/07 01:30:47 rdale Exp $
 
 @short A combobox to choose a font.
*/
public class KFontCombo extends KComboBox  {
	protected KFontCombo(Class dummy){super((Class) null);}


/** 
 Constructor

*/
	private native void newKFontCombo( QWidget parent, String name);
	public KFontCombo( QWidget parent, String name) {
		super((Class) null);
		newKFontCombo( parent, name);
	}
	private native void newKFontCombo( QWidget parent);
	public KFontCombo( QWidget parent) {
		super((Class) null);
		newKFontCombo( parent);
	}

/** 
 Constructor that takes an already initialzed font list

*/
	private native void newKFontCombo( String[] fonts, QWidget parent, String name);
	public KFontCombo( String[] fonts, QWidget parent, String name) {
		super((Class) null);
		newKFontCombo( fonts, parent, name);
	}
	private native void newKFontCombo( String[] fonts, QWidget parent);
	public KFontCombo( String[] fonts, QWidget parent) {
		super((Class) null);
		newKFontCombo( fonts, parent);
	}

/** 
 Destructor
     
*/
	protected native void finalize() throws InternalError;

/** 
 Sets the font list

*/
	public native void setFonts( String[] fonts);

/** 
 Set the listed fonts to bold or normal

*/
	public native void setBold( boolean bold);

/** 
 Retrieve the current bold status

*/
	public native boolean bold();

/** 
 Set the listed fonts to italic or regular

*/
	public native void setItalic( boolean bold);

/** 
 Retrieve the current italic status

*/
	public native boolean italic();

/** 
 Set the listed fonts to underlined or not underlined

*/
	public native void setUnderline( boolean bold);

/** 
 Retrieve the current underline status

*/
	public native boolean underline();

/** 
 Set the listed fonts to striked out or not

*/
	public native void setStrikeOut( boolean bold);

/** 
 Retrieve the current strike out status

*/
	public native boolean strikeOut();

/** 
 Set the listed fonts' size

*/
	public native void setSize( int size);

/** 
 Retrieve the current font size

*/
	public native int fontSize();

/** 
 Retrieve the user's setting of whether the items should be painted
 in the respective fonts or not

*/
	public static native boolean displayFonts();

/** 
 Updated the combo's {@link #listBox} to reflect changes made to the
 fonts' attributed
     
*/
	protected native void updateFonts();
}

/** Override these methods in subclasses of KFontCombo to customise event handling behaviour */
interface KFontComboEventHandling {

/** 

    
*/
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent e);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

