/***************************************************************************
                            KHTMLView.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Render and display HTML in a {@link QScrollView}.

 Suitable for use as an application's main view.

 @short 
 Render and display HTML in a @ref QScrollView.
*/
public class KHTMLView extends QScrollView  {
	protected KHTMLView(Class dummy){super((Class) null);}


/** 
 Construct a {@link KHTMLView}.
     
*/
	private native void newKHTMLView( KHTMLPart part, QWidget parent, String name);
	public KHTMLView( KHTMLPart part, QWidget parent, String name) {
		super((Class) null);
		newKHTMLView( part, parent, name);
	}
	private native void newKHTMLView( KHTMLPart part, QWidget parent);
	public KHTMLView( KHTMLPart part, QWidget parent) {
		super((Class) null);
		newKHTMLView( part, parent);
	}
	protected native void finalize() throws InternalError;

/** 
 Retrieve a pointer to the {@link KHTMLPart} that is
 rendering the page.

*/
	public native KHTMLPart part();
	public native int frameWidth();

/** 
 BCI: This function is provided for compatibility reasons only and 
 will be removed in KDE3.0.
 use sendEvent(view, Key_Tab) instead.
 Move the view towards the next link and
 draw a cursor around it

*/
	public native boolean gotoNextLink();

/** 
 BCI: This function is provided for compatibility reasons only and 
 will be removed in KDE3.0
 use sendEvent(view, Key_BackTab) instead.
 Move the view towards the next link and
 draw a cursor around it

*/
	public native boolean gotoPrevLink();

/** 
 BCI: This function is provided for compatibility reasons only and 
 will be removed in KDE3.0
 use sendEvent(view, Key_Return) instead.
 visualize that the item under the cursor
 has been pressed (true) or released(false)
     
*/
//	public native void toggleActLink( boolean arg1);

/** 
 Set a margin in x direction.
     
*/
	public native void setMarginWidth( int x);

/** 
 Retrieve the margin width.

 A return value of -1 means the default value will be used.
     
*/
	public native int marginWidth();
	public native void setMarginHeight( int y);
	public native int marginHeight();
	public native void setVScrollBarMode( int mode);
	public native void setHScrollBarMode( int mode);

/** 
 Print the HTML document.

*/
	public native void print();

/** 
 Paint the HTML document to a QPainter.
 The document will be scaled to match the width of
 rc and clipped to fit in the height.
 yOff determines the vertical offset in the document to start with.
 more, if nonzero will be set to true if the documents extends
 beyond the rc or false if everything below yOff was painted.

*/
	public native void paint( QPainter p, QRect rc, int yOff, int[] more);
	public native void paint( QPainter p, QRect rc);
	public native QWidget layout( boolean force);
	public native QLayout layout();
	protected native void clear();
	protected native boolean focusNextPrevChild( boolean next);
	protected native void drawContents( QPainter p, int clipx, int clipy, int clipw, int cliph);

/** 
 Scroll the view
     
*/
	protected native void doAutoScroll();
	protected native void slotPaletteChanged();
}

/** Override these methods in subclasses of KHTMLView to customise event handling behaviour */
interface KHTMLViewEventHandling {
	void keyPressEvent(QKeyEvent _ke);
	void keyReleaseEvent(QKeyEvent _ke);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void viewportDragMoveEvent(QDragMoveEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void contentsWheelEvent(QWheelEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void viewportMousePressEvent(QMouseEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);

/** 
 this function is called when the user releases a mouse button.
     
*/
	void viewportMouseReleaseEvent(QMouseEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);

/** 
 This function emits the {@link #doubleClick} signal when the user
 double clicks a <a href=...> tag.
     
*/
	void viewportMouseDoubleClickEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void viewportDragLeaveEvent(QDragLeaveEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void contentsDropEvent(QDropEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void contentsDragLeaveEvent(QDragLeaveEvent arg1);
	void viewportDropEvent(QDropEvent arg1);
	void dropEvent(QDropEvent arg1);
	void contentsMouseDoubleClickEvent(QMouseEvent arg1);
	void viewportDragEnterEvent(QDragEnterEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);

/** 
 This function is called when the user moves the mouse.
     
*/
	void viewportMouseMoveEvent(QMouseEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void contentsDragMoveEvent(QDragMoveEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void contentsMouseReleaseEvent(QMouseEvent arg1);
	void viewportWheelEvent(QWheelEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void contentsDragEnterEvent(QDragEnterEvent arg1);
	void contentsMouseMoveEvent(QMouseEvent arg1);
	void contentsMousePressEvent(QMouseEvent arg1);
	void closeEvent(QCloseEvent arg1);
	void viewportPaintEvent(QPaintEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void viewportResizeEvent(QResizeEvent arg1);
	void resizeEvent(QResizeEvent event);
}

