/***************************************************************************
                            KIconDialog.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Dialog for interactive selection of icons. Use the function
 selectIcon() let the user select an icon.
 
 @short 
 Dialog for interactive selection of icons.
*/
public class KIconDialog extends KDialogBase  {
	protected KIconDialog(Class dummy){super((Class) null);}


/**  Construct the iconloader dialog. Uses the global iconloader. 
*/
	private native void newKIconDialog( QWidget parent, String name);
	public KIconDialog( QWidget parent, String name) {
		super((Class) null);
		newKIconDialog( parent, name);
	}
	private native void newKIconDialog();
	public KIconDialog() {
		super((Class) null);
		newKIconDialog();
	}

/**  Alternate constructor to use a different iconloader. 
*/
	private native void newKIconDialog( KIconLoader loader, QWidget parent, String name);
	public KIconDialog( KIconLoader loader, QWidget parent, String name) {
		super((Class) null);
		newKIconDialog( loader, parent, name);
	}
	private native void newKIconDialog( KIconLoader loader);
	public KIconDialog( KIconLoader loader) {
		super((Class) null);
		newKIconDialog( loader);
	}
	protected native void finalize() throws InternalError;

/** 
 Sets a strict icon size policy for allowed icons. When true,
 only icons of the specified group's size in selectIcon are shown.
 When false, icons not available at the desired group's size will
 also be selectable.
     
*/
	public native void setStrictIconSize( boolean b);

/** 
 Pops up the dialog an lets the user select an icon.

*/
	public native String selectIcon( int group, int context, boolean user);
}

/** Override these methods in subclasses of KIconDialog to customise event handling behaviour */
interface KIconDialogEventHandling {

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager 
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior 
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

