/***************************************************************************
                            KImageEffect.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class includes various {@link QImage} based graphical effects. 

Everything is
 static, so there is no need to create an instance of this class. You can
 just call the static methods. They are encapsulated here merely to provide
 a common namespace.
 
 @short 
 This class includes various @ref QImage based graphical effects.
*/
public class  KImageEffect implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KImageEffect(Class dummy){}


/** 
 Create a gradient from color a to color b of the specified type.

*/
	public static native QImage gradient( QSize size, QColor ca, QColor cb, int type, int ncols);
	public static native QImage gradient( QSize size, QColor ca, QColor cb, int type);

/** 
 Create an unbalanced gradient.

 An unbalanced gradient is a gradient where the transition from
 color a to color b is not linear, but in this case, exponential.

*/
	public static native QImage unbalancedGradient( QSize size, QColor ca, QColor cb, int type, int xfactor, int yfactor, int ncols);
	public static native QImage unbalancedGradient( QSize size, QColor ca, QColor cb, int type);

/** 
 Blend the provided image into a background of the indicated color.

*/
	public static native QImage blend( QImage image, float initial_intensity, QColor bgnd, int eff, boolean anti_dir);
	public static native QImage blend( QImage image, float initial_intensity, QColor bgnd, int eff);

/** 
 Blend an image into another one, using a gradient type
 for blending from one to another.

*/
	public static native QImage blend( QImage image1, QImage image2, int gt, int xf, int yf);
	public static native QImage blend( QImage image1, QImage image2, int gt);

/** 
 Blend an image into another one, using a color channel of a 
 third image for the decision of blending from one to another.

*/
	public static native QImage blend( QImage image1, QImage image2, QImage blendImage, int channel);

/** 
 Blend an image into another one, using alpha in the expected way.

*/
	public static native boolean blend( QImage upper, QImage lower, QImage output);

/** 
 Blend an image into another one, using alpha in the expected way and
 over coordinates <code>x</code> and <code>y</code> with respect to the lower image.
 The output is a QImage which is the <code>upper</code> image already blended
 with the <code>lower</code> one, so its size will be (in general) the same than
 <code>upper</code> instead of the same size than <code>lower</code> like the method above.
 In fact, the size of <code>output</code> is like upper's one only when it can be
 painted on lower, if there has to be some clipping, output's size will
 be the clipped area and x and y will be set to the correct up-left corner
 where the clipped rectangle begins.
     
*/
	public static native boolean blend( int x, int y, QImage upper, QImage lower, QImage output);

/** 
 Blend an image into another one, using alpha in the expected way and
 over coordinates <code>x</code> and <code>y</code> with respect to the lower image.
 The output is painted in the own <code>lower</code> image. This is an optimization
 of the {@link blend} method above provided by convenience.
     
*/
	public static native boolean blendOnLower( int x, int y, QImage upper, QImage lower);

/** 
 Modifies the intensity of a pixmap's RGB channel component.

*/
	public static native QImage channelIntensity( QImage image, float percent, int channel);

/** 
 Fade an image to a certain background color.

 The number of colors will not be changed.

*/
	public static native QImage fade( QImage img, float val, QColor color);

/** 
 This recolors a pixmap. The most dark color will become color a,
 the most bright one color b, and in between.

*/
	public static native QImage flatten( QImage image, QColor ca, QColor cb, int ncols);
	public static native QImage flatten( QImage image, QColor ca, QColor cb);

/** 
 Build a hash on any given {@link QImage}

*/
	public static native QImage hash( QImage image, int lite, int spacing);
	public static native QImage hash( QImage image);

/** 
 Either brighten or dim the image by a specified percent.
 For example, .50 will modify the colors by 50%.

*/
	public static native QImage intensity( QImage image, float percent);

/** 
 Modulate the image with a color channel of another image.

*/
	public static native QImage modulate( QImage image, QImage modImage, boolean reverse, int type, int factor, int channel);

/** 
 Convert an image to grayscale.

*/
	public static native QImage toGray( QImage image, boolean fast);
	public static native QImage toGray( QImage image);

/** 
 Desaturate an image evenly.

*/
	public static native QImage desaturate( QImage image, float arg1);
	public static native QImage desaturate( QImage image);

/** 
 Modifie the contrast of an image.

*/
	public static native QImage contrast( QImage image, int c);

/** 
 Dither an image using Floyd-Steinberg dithering for low-color
 situations.

*/
	public static native QImage dither( QImage img, QColor palette, int size);

/** 
 Paints (copy) an image <code>src</code> over another one (<code>tgt</code>) 
 at the specified point, x,y relative to tgt.
 <code>return</code> Returns true if everything was ok, or false
 if it couldn't be copied (because they're not 32-bit images).
 Note that if you specify x,y outside a reasonable range
 (outside the tgt image), then the return value is true.
     
*/
	public static native boolean paint( int x, int y, QImage tgt, QImage src);
	public static final int VerticalGradient = 0;
	public static final int HorizontalGradient = 1;
	public static final int DiagonalGradient = 2;
	public static final int CrossDiagonalGradient = 3;
	public static final int PyramidGradient = 4;
	public static final int RectangleGradient = 5;
	public static final int PipeCrossGradient = 6;
	public static final int EllipticGradient = 7;
	public static final int Red = 0;
	public static final int Green = 1;
	public static final int Blue = 2;
	public static final int Gray = 3;
	public static final int All = 4;
	public static final int NorthLite = 0;
	public static final int NWLite = 1;
	public static final int WestLite = 2;
	public static final int SWLite = 3;
	public static final int SouthLite = 4;
	public static final int SELite = 5;
	public static final int EastLite = 6;
	public static final int NELite = 7;
	public static final int Intensity = 0;
	public static final int Saturation = 1;
	public static final int HueShift = 2;
	public static final int Contrast = 3;
}
