/***************************************************************************
                            KMimeType.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Represent a mime type, like "text/plain".

 The starting point you need is often the static methods.
 See also {@link KServiceType}.
 
 @short 
 Represent a mime type, like "text/plain".
*/
public class KMimeType extends KServiceType  {
	protected KMimeType(Class dummy){super((Class) null);}


/** 
 Constructor.

 You may pass in arguments to create a mimetype with
 specific properties.
   
*/
	private native void newKMimeType( String _fullpath, String _type, String _icon, String _comment, String[] _patterns);
	public KMimeType( String _fullpath, String _type, String _icon, String _comment, String[] _patterns) {
		super((Class) null);
		newKMimeType( _fullpath, _type, _icon, _comment, _patterns);
	}

/** 
 Construct a mimetype and take all information from a config file.
   
*/
	private native void newKMimeType( String _fullpath);
	public KMimeType( String _fullpath) {
		super((Class) null);
		newKMimeType( _fullpath);
	}

/** 
 Construct a mimetype and take all information from a desktop file.
   
*/
	private native void newKMimeType( KDesktopFile config);
	public KMimeType( KDesktopFile config) {
		super((Class) null);
		newKMimeType( config);
	}

/** 

 The stream must already be positionned at the correct offset
   
*/
	private native void newKMimeType( QDataStream _str, int offset);
	public KMimeType( QDataStream _str, int offset) {
		super((Class) null);
		newKMimeType( _str, offset);
	}
	protected native void finalize() throws InternalError;

/** 
 Return the filename of the icon associated with the mimetype.

 The arguments are unused, but provided so that {@link KMimeType} - derived classes
 can use them (e.g. {@link KFolderType} uses the URL to return one out of 2 icons)

*/
	public native String icon( String arg1, boolean arg2);

/** 
 This function differs from the above only in that a {@link KURL} may be
 provided instead of a {@link String} for convenience.
   
*/
	public native String icon( KURL arg1, boolean arg2);

/** 
 Use this function only if you don't have a special URL
 for which you search a pixmap.

 This function is useful to find
 out, which icon is usually chosen for a certain mime type. Since
 no URL is passed, it is impossible to obey icon hints in desktop
 entries for example.

*/
	public native QPixmap pixmap( int _group, int _force_size, int _state, String _path);
	public native QPixmap pixmap( int _group);

/** 
 Find the pixmap for a given file of this mimetype.

 Convenience method that uses {@link #icon}, but also locates and
 load the pixmap.

*/
	public native QPixmap pixmap( KURL _url, int _group, int _force_size, int _state, String _path);
	public native QPixmap pixmap( KURL _url, int _group);

/** 

*/
	public native String comment();

/** 
 The arguments are unused, but provided so that {@link KMimeType} derived classes
 can use them.

*/
	public native String comment( String arg1, boolean arg2);

/** 
 This function differs from the above only in that a {@link KURL} may be
 provided instead of a {@link String} for convenience.
   
*/
	public native String comment( KURL arg1, boolean arg2);

/** 
 Retrieve the list of patterns associated with the MIME Type.
   
*/
	public native ArrayList patterns();

/** 
 Load the mimetype from a stream.
   
*/
	public native void load( QDataStream arg1);

/** 
 Save the mimetype to a stream.
   
*/
	public native void save( QDataStream arg1);
	public native QVariant property( String _name);
	public native ArrayList propertyNames();

/** 
 Convenience method to find the pixmap for a URL

 Call this one when you don't know the mimetype.

*/
	public static native QPixmap pixmapForURL( KURL _url, long _mode, int _group, int _force_size, int _state, String _path);
	public static native QPixmap pixmapForURL( KURL _url);

/** 
 The same functionality as pixmapForURL, but this method returns the name
 of the icon to load. You'll have to use KIconLoader to load the pixmap for it.
 The advantage of this method is that you can store the result, and then use it
 later on for any kind of size.
   
*/
	public static native String iconForURL( KURL _url, long _mode);

/** 
 Retrieve a pointer to the mime type <code>_name</code> or a pointer to the default
         mime type "application/octet-stream".

 null is <em>never</em> returned.

 <em>Very</em> <em>important</em>: Don't store the result in a {@link KMimeType}  !

*/
	public static native int mimeType( String _name);

/** 
 This function looks at mode_t first.

 If that does not help it
 looks at the extension.  This is find for FTP, FILE, TAR and
 friends, but is not for HTTP ( cgi scripts! ). You should use
 {@link KRun} instead, but this function returns immediately while
 {@link KRun} is async. If no extension matches, then
 {@link KMimeMagic} is used if the URL a local file or
 "application/octet-stream" is returned otherwise.

*/
	public static native int findByURL( KURL _url, long _mode, boolean _is_local_file, boolean _fast_mode);
	public static native int findByURL( KURL _url);

/** 
 Get all the mimetypes.

 Useful for showing the list of
 available mimetypes.
 More memory consuming than the ones above, don't use unless
 really necessary.
   
*/
	public static native List allMimeTypes();

/** 

*/
	public static native String defaultMimeType();
	protected native void loadInternal( QDataStream arg1);
	protected native void init( KDesktopFile arg1);

/** 
 Signal a missing mime type
   
*/
	protected static native void errorMissingMimeType( String _type);

/** 
 This function makes sure that the default mime type exists.
   
*/
	protected static native void buildDefaultType();

/** 
 This function makes sure that vital mime types are installed.
   
*/
	protected static native void checkEssentialMimeTypes();
}
