/***************************************************************************
                            KRootProp.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Access KDE desktop resources stored on the root window.

 A companion to the {@link KConfig} class.

 The {@link KRootProp} class is used for reading and writing configuration entries
 to properties on the root window.

 All configuration entries are of the form "key=value".

 @author Mark Donohoe (donohe@kde.org)

 @version $Id: KRootProp.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short 
 Access KDE desktop resources stored on the root window.
*/
public class  KRootProp implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KRootProp(Class dummy){}


/** 
 Construct a {@link KRootProp} object for the property <code>rProp.</code>

*/
	private native void newKRootProp( String rProp);
	public KRootProp( String rProp) {
		newKRootProp( rProp);
	}
	private native void newKRootProp();
	public KRootProp() {
		newKRootProp();
	}

/** 
 Destructor.

 Writes back any dirty configuration entries.

*/
	protected native void finalize() throws InternalError;

/** 
 Specify the property in which keys will be searched.

*/
	public native void setProp( String rProp);
	public native void setProp();

/** 
 Retrieve the name of the property under which keys are searched.

*/
	public native String prop();

/** 
 Destroy the property completely.

 I.e. all entries will be cleared
 and the property will be removed from the root window.

*/
	public native void destroy();

/** 
 Read the value of an entry specified by <code>rKey</code> in the current property

*/
	public native String readEntry( String rKey, String pDefault);

/** 
 Read a numerical value.

 Read the value of an entry specified by <code>rKey</code> in the current property
 and interpret it numerically.

*/
	public native int readNumEntry( String rKey, int nDefault);
	public native int readNumEntry( String rKey);

/** 
 Read a {@link QFont}.

 Read the value of an entry specified by <code>rKey</code> in the current property
 and interpret it as a font object.

*/
	public native QFont readFontEntry( String rKey, QFont pDefault);
	public native QFont readFontEntry( String rKey);

/** 
 Read a {@link QColor}.

 Read the value of an entry specified by <code>rKey</code> in the current property
 and interpret it as a color.

*/
	public native QColor readColorEntry( String rKey, QColor pDefault);
	public native QColor readColorEntry( String rKey);

/** 
 {@link #writeEntry} overridden to accept a const {@link String} argument.

 This is stored to the current property when destroying the
 config object or when calling {@link #sync}.

*/
	public native String writeEntry( String rKey, String rValue);

/**  Write the key value pair.
 Same as above, but write a numerical value.

*/
	public native String writeEntry( String rKey, int nValue);

/**  Write the key value pair.
 Same as above, but write a font.

*/
	public native String writeEntry( String rKey, QFont rFont);

/**  Write the key value pair.
 Same as above, but write a color.

*/
	public native String writeEntry( String rKey, QColor rColor);

/** 
 Remove an entry.

*/
	public native String removeEntry( String rKey);

/** 
 Get a list of all keys.

*/
	public native ArrayList listEntries();

/**  Flush the entry cache.
 Write back dirty configuration entries to the current property,
  This is called automatically from the destructor.

*/
	public native void sync();
}
