/***************************************************************************
                            KSelector.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KSelector is the base class for other widgets which
 provides the ability to choose from a one-dimensional
 range of values. An example is the {@link KGradientSelector}
 which allows to choose from a range of colors.

 A custom drawing routine for the widget surface has
 to be provided by the subclass.
 
 @short 
 KSelector is the base class for other widgets which
 provides the ability to choose from a one-dimensional
 range of values.
*/
public class KSelector extends QWidget implements  QRangeControlInterface {
	protected KSelector(Class dummy){super((Class) null);}


/** 
 Constructs a horizontal one-dimensional selection widget.
   
*/
	private native void newKSelector( QWidget parent, String name);
	public KSelector( QWidget parent, String name) {
		super((Class) null);
		newKSelector( parent, name);
	}
	private native void newKSelector();
	public KSelector() {
		super((Class) null);
		newKSelector();
	}

/** 
 Constructs a one-dimensional selection widget with
 a given orientation.
   
*/
	private native void newKSelector( int o, QWidget parent, String name);
	public KSelector( int o, QWidget parent, String name) {
		super((Class) null);
		newKSelector( o, parent, name);
	}
	private native void newKSelector( int o);
	public KSelector( int o) {
		super((Class) null);
		newKSelector( o);
	}
	protected native void finalize() throws InternalError;

/** 

*/
	public native int orientation();

/** 

*/
	public native QRect contentsRect();

/** 
 Sets the indent option of the widget to i.
 This determines whether a shaded frame is drawn.
   
*/
	public native void setIndent( boolean i);

/** 

*/
	public native boolean indent();

/** 
 Override this function to draw the contents of the control.
 The default implementation doesn nothing.

 Draw only within contentsRect().
   
*/
	protected native void drawContents( QPainter arg1);

/** 
 Override this function to draw the cursor which
 indicates the currently value. This function is
 always called twice, once with argument show=false
 to clear the old cursor, once with argument show=true
 to draw the new one.
   
*/
	protected native void drawArrow( QPainter painter, boolean show, QPoint pos);

        // From QRangeControlInterface

        public native int value();
        public native void setValue( int arg1);
        public native void addPage();
        public native void subtractPage();
        public native void addLine();
        public native void subtractLine();
        public native int minValue();
        public native int maxValue();
        public native void setRange( int minValue, int maxValue);
        public native int lineStep();
        public native int pageStep();
        public native void setSteps( int line, int page);
        public native int bound( int arg1);
        protected native int positionFromValue( int val, int space);
        protected native int valueFromPosition( int pos, int space);
        protected native void directSetValue( int val);
        protected native int prevValue();
        protected native void valueChange();
        protected native void rangeChange();
        protected native void stepChange();

}

/** Override these methods in subclasses of KSelector to customise event handling behaviour */
interface KSelectorEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);

/** 

   
*/
	void mousePressEvent(QMouseEvent e);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);

/** 

   
*/
	void mouseMoveEvent(QMouseEvent e);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);

/** 

   
*/
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

