/***************************************************************************
                            KSocket.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 A TCP/IP client socket.

 You can connect this socket to any Internet address. 

 The socket gives you three signals: When ready for reading, 
 ready for writing or if the connection is broken.  
 Using {@link #socket} you get a file descriptor
 which you can use with the usual UNIX function like {@link #write} or
  {@link #read}. 
 If you have already such a socket identifier you can construct a KSocket
 on this identifier. 

 If {@link #socket} delivers a value of -1 or less, the connection 
 was not successful.

 @author Torben Weis <weis@uni-frankfurt.de>

 @version $Id: KSocket.java,v 1.2 2001/05/07 01:30:47 rdale Exp $

 @short a TCP/IP client socket.
 
*/
public class KSocket extends QObject  {
	protected KSocket(Class dummy){super((Class) null);}


/**  
 Create a KSocket with the provided file descriptor.

*/
	private native void newKSocket( int _sock);
	public KSocket( int _sock) {
		super((Class) null);
		newKSocket( _sock);
	}

/**  
 Create a socket and connect to a host.

*/
	private native void newKSocket( String _host, short _port, int timeOut);
	public KSocket( String _host, short _port, int timeOut) {
		super((Class) null);
		newKSocket( _host, _port, timeOut);
	}
	private native void newKSocket( String _host, short _port);
	public KSocket( String _host, short _port) {
		super((Class) null);
		newKSocket( _host, _port);
	}

/**  
 Connects to a UNIX domain socket.

*/
	private native void newKSocket( String _path);
	public KSocket( String _path) {
		super((Class) null);
		newKSocket( _path);
	}

/**  
 Destructor. Closes the socket if it is still open.
     
*/
	protected native void finalize() throws InternalError;

/**  
 Returns a file descriptor for this socket.
 Returns -1 when an error occured.
     
*/
	public native int socket();

/**  
 Enable the socket for reading.

 If you enable read mode, the socket will emit the signal
 {@link #readEvent} whenever there is something to read out of this
 socket.
     
*/
	public native void enableRead( boolean arg1);

/**  
 Enable the socket for writing.

 If you enable write mode, the socket will emit the signal
 {@link #writeEvent} whenever the socket is ready for writing.

 Warning: If you forget to call enableWrite(false) when you are
 not ready to send data, you will get lots of writeEvent() signals,
 in the order of thousands a second !
     
*/
	public native void enableWrite( boolean arg1);

/** 
 Return address.
 This function is dumb. Don't ever use it
 if you need the peer address of this socket, use {@link KExtendedSocket#peerAddress}
 instead

     
*/
	public native long ipv4_addr();

/**  
 Connected to the writeNotifier.

 Called when
  the socket is ready for writing.
     
*/
	public native void slotWrite( int arg1);

/**  
 Connected to the readNotifier.

 Called when
  the socket is ready for reading.
     
*/
	public native void slotRead( int arg1);

/** 
  A small wrapper around {@link #gethostbyname} and such.
  Don't use this in new programs. Use {@link KExtendedSocket#lookup}

      
*/
	public static native boolean initSockaddr( int server_name, String hostname, short port, int domain);
	public static native boolean initSockaddr( int server_name, String hostname, short port);
	protected native boolean connect( String _host, short _port);
	protected native boolean connect( String _path);
	protected native boolean init_sockaddr( String hostname, short port);
}

/** Override these methods in subclasses of KSocket to customise event handling behaviour */
interface KSocketEventHandling {
	void childEvent(QChildEvent arg1);
	void timerEvent(QTimerEvent arg1);
}

