/***************************************************************************
                            KTarBase.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 @author David Faure <faure@kde.org>
 
 @short generic class for reading/writing tar archives
 Doesn't really have any reason for being separated from KTarGz anymore.
 Will be merged with KTarGz and renamed to KTar in KDE 3.0.
*/
public class  KTarBase implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KTarBase(Class dummy){}


/** 
 Opens the tar file/data for reading or writing.

*/
	public native boolean open( int mode);

/** 
 Closes the tar file/data.

*/
	public native void close();

/** 

*/
	public native boolean isOpened();

/** 
 If a tar file is opened for writing then you can add new directories
 using this function. KTar won't write one directory twice.
   
*/
	public native void writeDir( String name, String user, String group);

/** 
 If a tar file is opened for writing then you can add a new file
 using this function. If the file name is for example "mydir/test1" then
 the directory "mydir" is automatically appended first if that did not
 happen yet.
   
*/
	public native void writeFile( String name, String user, String group, int size, String data);

/** 
 If a tar file is opened for reading, then the contents
 of the file can be accessed via this function.
   
*/
	public native KTarDirectory directory();
	public native QIODeviceInterface device();
	public native void setDevice( QIODeviceInterface dev);
}
