/***************************************************************************
                            KTipDatabase.java -  description
                             -------------------
    begin                : Sun May 13 13:42:09 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun May 13 13:42:09 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A database for tips-of-the-day.

 This class provides convenient access to a database containing
 tips of the day. The database is stored in a XML file and parsed
 when a KTipDatabase object is created.

 Once the file is read in, you can access the tips to display
 them in the tip of the day dialog.

 
 @author Matthias Hoelzer-Kluepfel <mhk@caldera.de>

 @short 
 A database for tips-of-the-day.
*/
public class  KTipDatabase implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KTipDatabase(Class dummy){}


/** 
 The constructor.

 This reads in the tips from a file with the given name. If no name is
 given, a file called 'application-name/tips' will be loaded.

*/
	private native void newKTipDatabase( String tipFile);
	public KTipDatabase( String tipFile) {
		newKTipDatabase( tipFile);
	}
	private native void newKTipDatabase();
	public KTipDatabase() {
		newKTipDatabase();
	}

/** 
 Returns the current tip.
   
*/
	public native String tip();

/** 
 The next tip will become the current one.
   
*/
	public native void nextTip();

/** 
 The previous tip will become the current one.
   
*/
	public native void prevTip();
}
