/***************************************************************************
                            KXYSelector.java -  description
                             -------------------
    begin                : Fri May  4 14:00:25 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri May  4 14:00:25 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KXYSelector is the base class for other widgets which
 provides the ability to choose from a two-dimensional
 range of values. The currently chosen value is indicated
 by a cross. An example is the {@link KHSSelector} which
 allows to choose from a range of colors, and which is
 used in KColorDialog.

 A custom drawing routine for the widget surface has
 to be provided by the subclass.
 
 @short 
 KXYSelector is the base class for other widgets which
 provides the ability to choose from a two-dimensional
 range of values.
*/
public class KXYSelector extends QWidget  {
	protected KXYSelector(Class dummy){super((Class) null);}


/** 
 Constructs a two-dimensional selector widget which
 has a value range of [0..100] in both directions.
   
*/
	private native void newKXYSelector( QWidget parent, String name);
	public KXYSelector( QWidget parent, String name) {
		super((Class) null);
		newKXYSelector( parent, name);
	}
	private native void newKXYSelector();
	public KXYSelector() {
		super((Class) null);
		newKXYSelector();
	}

/** 
 Destructs the widget.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Sets the current values in horizontal and
 vertical direction.
   
*/
	public native void setValues( int _xPos, int _yPos);

/** 
 Sets the range of possible values.
   
*/
	public native void setRange( int _minX, int _minY, int _maxX, int _maxY);

/** 

*/
	public native int xValue();

/** 

*/
	public native int yValue();

/** 

*/
	public native QRect contentsRect();

/** 
 Override this function to draw the contents of the widget.
 The default implementation doesn nothing.

 Draw within contentsRect() only.
   
*/
	protected native void drawContents( QPainter arg1);

/** 
 Override this function to draw the cursor which
 indicates the currently selected value pair.
   
*/
	protected native void drawCursor( QPainter p, int xp, int yp);
}

/** Override these methods in subclasses of KXYSelector to customise event handling behaviour */
interface KXYSelectorEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);

/** 

   
*/
	void mousePressEvent(QMouseEvent e);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);

/** 

   
*/
	void mouseMoveEvent(QMouseEvent e);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void closeEvent(QCloseEvent arg1);

/** 

   
*/
	void paintEvent(QPaintEvent e);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

