#ifndef KOEVENTVIEWER_H
#define KOEVENTVIEWER_H
// $Id: koeventviewer.h,v 1.7 2001/04/18 23:28:57 cschumac Exp $
//
// Viewer widget for events.
//

#include <qtextview.h>

#include <event.h>

using namespace KCal;

class KOEventViewer : public QTextView {
    Q_OBJECT
  public:
    KOEventViewer(QWidget *parent=0,const char *name=0);
    virtual ~KOEventViewer();

    void setEvent(Event *event);
    void setTodo(Todo *event);
    
    void appendEvent(Event *event);
    void appendTodo(Todo *event);
    
    void clearEvents(bool now=false);
    
  protected:
    void addTag(const QString & tag,const QString & text);

    void formatCategories(Incidence *event);
    void formatAttendees(Incidence *event);
    void formatReadOnly(Incidence *event);

  private:
    QTextView *mEventTextView;

    QString mText;    
};

#endif
