#ifndef JOURNALENTRY_H
#define JOURNALENTRY_H
// $Id: journalentry.h,v 1.4 2001/04/18 23:28:57 cschumac Exp $
//
// Widget showing one Journal entry

#include <qframe.h>

#include <calendar.h>

class QLabel;
class QMultiLineEdit;

using namespace KCal;

class JournalEntry : public QFrame {
    Q_OBJECT
  public:
    JournalEntry(Calendar *,QWidget *parent);
    virtual ~JournalEntry();
    
    void setJournal(Journal *);
    Journal *journal() const;

    void setDate(const QDate &);

    void clear();

    void flushEntry();

  protected slots:
    void setDirty();

  protected:    
    bool eventFilter( QObject *o, QEvent *e );

    void writeJournal();
    
  private:
    Calendar *mCalendar;
    Journal *mJournal;
    QDate mDate;
    
    QLabel *mTitleLabel;
    QMultiLineEdit *mEditor;

    bool mDirty;
};

#endif
