/* This file is part of the KDE project
   Copyright (C) 2001 Holger Freyther <freyther@yahoo.com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; version 2
   of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef _kmetamenu_h
#define _kmetamenu_h

#include <qpopupmenu.h>
#include <qptrlist.h>

#include <kaction.h>

class KConfig;
class QIconSet;
class KDirMenu;
class QStringList;
class KURL;
class KMetaMenu : public QPopupMenu {
    Q_OBJECT
public:

     KMetaMenu( QWidget *parent, const QString &target_text, const QString &key );
     KMetaMenu();
     ~KMetaMenu();
     void writeConfig( const QString &path );
public slots:
     void slotFileChosen( const QString &path);
     void slotFastPath( );
     void slotBrowse( );
signals:
     void fileChosen( const QString &path );
     void fileChosen( const KURL &url );
private:
     QIconSet p_root;
     QIconSet p_home;
     QIconSet p_etc;
     KDirMenu *m_root;
     KDirMenu *m_home;
     KDirMenu *m_etc;
     QStringList list;
     KConfig *conf;
     KAction *m_browse;
     QString group;
     QPtrList<KAction> actions;
};

#endif

