/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qlabel.h>
#include <qlayout.h>

#include <klocale.h>

#include "abouttab.h"
#include "version.h"


AboutTab::AboutTab(QWidget *parent, const char *name) : QWidget(parent, name)
{
  QString  version;
  QString  copyright = i18n("Copyright (C) 1999\nThorsten Westheider");
  QString  gpl;
  
  version = i18n("Version %1\n\n").arg(KSYSCTRL_VERSION);

  gpl  = i18n("This program is free software; you can redistribute it and/or modify "
              "it under the terms of the GNU General Public License as published by "
              "the Free Software Foundation; either version 2 of the License, or "
              "(at your option) any later version.\n");

  QFrame  *aboutframe = new QFrame(this, "aboutframe");
  aboutframe->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  aboutframe->setLineWidth(1);
  
  QLabel  *ksysclabel = new QLabel(i18n("The KDE System Control Tool"), aboutframe, "ksysclabel");
  QFont font = ksysclabel->font();
  font.setPointSize(24);
  font.setBold(true);
  ksysclabel->setFont(font);
  ksysclabel->setAlignment(AlignHCenter | WordBreak);
  
  QLabel  *desclabel  = new QLabel(version+copyright, aboutframe, "copyrlabel");
  desclabel->setAlignment(AlignHCenter | WordBreak);
  
  QLabel  *gpllabel   = new QLabel(gpl, aboutframe, "gpllabel");
  gpllabel->setAlignment(WordBreak);
    
  QVBoxLayout  *outsidelayout = new QVBoxLayout(this,       16, 4, "outsidelayout");

  outsidelayout->addWidget(aboutframe);
  
  QVBoxLayout  *insidelayout  = new QVBoxLayout(aboutframe, 16, 4, "insidelayout");
  
  insidelayout->addSpacing(16);
  
  QHBoxLayout  *titlelayout   = new QHBoxLayout(insidelayout,   4, "titlelayout");
  titlelayout->addStretch(1);
  titlelayout->addWidget(ksysclabel);  
  titlelayout->addStretch(1);
  
  insidelayout->addSpacing(16);
  insidelayout->addWidget(desclabel);
  insidelayout->addSpacing(16);
  insidelayout->addWidget(gpllabel);
  insidelayout->addStretch(1);
  insidelayout->activate();
  
  outsidelayout->activate();
}


