/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qlayout.h>

#include <klocale.h>

#include "devicelist.h"
#include "reschangedlg.h"

extern DeviceList  *devicelist;


ResourceChangeDialog::ResourceChangeDialog(ResourceBaseConfig *baseconf, Resource *res, 
					   Device *device, 
					   QWidget *parent, 
					   const char *name) : QDialog(parent, name, true),
                                           			    _baseconf(baseconf),
                                                                    _res(res),
                                                                    _device(device)
{
  QString       hint, title, conflict;
  ResourceList  *alternatives = (_baseconf) ? _baseconf->alternativeResources(_res) : 0L;
  int           rescount      = (alternatives) ? alternatives->count() : 1;
  
  hint   = i18n("Enter the desired %1 for this device.").arg(res->resourceLowerName());

  title  = i18n("Change %1").arg(res->resourceLowerName());
  
  setCaption(title);
  setMinimumSize(300, 300);
  
  _hintlabel = new QLabel(hint, this, "hintlabel");
  _hintlabel->setAlignment(WordBreak);
  _hintlabel->adjustSize();

  QVBoxLayout  *toplayout = new QVBoxLayout(this, 10, 4, "toplayout");  
  toplayout->addWidget(_hintlabel);
  toplayout->addSpacing(16);
  	
  _resspinbox = new ResourceSpinBox(alternatives, rescount, _res, this, "resspinbox");     
  _resspinbox->setWrapping(true);
  _resspinbox->adjustSize();
  
  _valuelabel = new QLabel(_resspinbox, i18n("&Value:"), this, "valuelabel");
  _valuelabel->adjustSize();

  QHBoxLayout  *vallayout = new QHBoxLayout(toplayout, 8, "vallayout");
  vallayout->addWidget(_valuelabel);
  vallayout->addSpacing(4);
  vallayout->addWidget(_resspinbox, 1);
  vallayout->addSpacing(50);
  toplayout->addSpacing(16);

  _conflictgbox = new QGroupBox(i18n("Information (Conflict)"), this, "conflictgbox");
  
  conflict  = i18n("The chosen setting leads to conflict with the following devices:");
  
  _conflictlabel = new QLabel(conflict, _conflictgbox, "conflictlabel");
  _conflictlabel->setAlignment(WordBreak);
  _conflictlabel->adjustSize();
  
  _conflictdisplay = new ConflictDisplay(_conflictgbox, "conflictdisplay");
   
  connect(_resspinbox, SIGNAL(valueChanged(int)), SLOT(slotResourceChanged(int))); 
   
  QVBoxLayout  *conflayout = new QVBoxLayout(_conflictgbox, 16, 4, "conflayout");  
  conflayout->addSpacing(10);
  conflayout->addWidget(_conflictlabel);
  conflayout->addWidget(_conflictdisplay, 1);
  conflayout->activate();
  
  toplayout->addWidget(_conflictgbox);
  toplayout->addSpacing(4);
  
  _ok = new QPushButton(i18n("OK"), this, "ok");
  _ok->adjustSize();
  _ok->setDefault(true);  
  connect(_ok, SIGNAL(clicked()), SLOT(accept()));
  
  _cancel = new QPushButton(i18n("Cancel"), this, "cancel");
  _cancel->adjustSize();
  connect(_cancel, SIGNAL(clicked()), SLOT(reject()));

  QHBoxLayout  *butlayout = new QHBoxLayout(toplayout, 4, "butlayout");
  butlayout->addStretch(1);
  butlayout->addWidget(_ok);
  butlayout->addWidget(_cancel);

  toplayout->activate();
  resize(300, 300);		// Why is Qt constantly ignoring MinimumSizes???
  
  slotResourceChanged(_resspinbox->initialValue());  // Initial conflict check	
}

/*
 * Private slots
 ****************/
 
void  ResourceChangeDialog::slotResourceChanged(int value)
{
  QList<Resource>  reslist;
  QList<Conflict>  conflictlist;
  
  reslist.append(_newsetting = _resspinbox->resource(value));
  
  conflictlist = devicelist->conflicts(_device, reslist, true);
  
  if ((_conflict = !conflictlist.isEmpty())) _conflictdisplay->showConflicts(conflictlist);
  else                                       _conflictdisplay->reset();
}

