//////////////////////////////////////////////////////////////         
//      $Id: options.cpp,v 1.10 2000/06/11 15:18:15 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#include "../config.h"

#include "kpackage.h"
#include "managementWidget.h"
#include "pkgInterface.h"
#include "options.h"
#include "cache.h"
#include <klocale.h>

extern Params *params;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
Options::Options(QWidget *parent)
    : QDialog(parent, 0, FALSE){

    readSettings();
    if (DCache >= Params::SESSION) {
      cacheObj::clearDCache(); // clear dir caches if needed
    }
    if (PCache >= Params::SESSION) {
      cacheObj::clearPCache(); // clear package caches if needed
    }

    tab = new QTabDialog(0,"Options");
    tab->setCaption("Options");

     {
      bc = new QButtonGroup(tab);
      bc->setTitle(i18n("Cache remote package directories"));
      connect( bc, SIGNAL(clicked(int)), SLOT(PDCache(int)) );

      QVBoxLayout* vc = new QVBoxLayout( bc, 15, 10, "vc");
      vc->addSpacing( bc->fontMetrics().height() );

      dcache[0] = new QRadioButton(i18n("Always"),bc);
      vc->addWidget(dcache[0]);

      dcache[1] = new QRadioButton(i18n("During as session"),bc);
      vc->addWidget(dcache[1]);

      dcache[2] = new QRadioButton(i18n("Never"),bc);
      vc->addWidget(dcache[2]);

      if (DCache > 2)
	DCache = 2;
      dcache[DCache]->setChecked(TRUE);
    }
    tab->addTab(bc,i18n("Directory Cache"));

    {
      bp = new QButtonGroup(tab);
      bp->setTitle(i18n("Cache remote package files"));
      connect( bp, SIGNAL(clicked(int)), SLOT(PPCache(int)) );

      QVBoxLayout* vp = new QVBoxLayout( bp, 15, 10, "vp");
      vp->addSpacing( bp->fontMetrics().height() );

      pcache[0] = new QRadioButton(i18n("Always"),bp);
      vp->addWidget(pcache[0]);

      pcache[1] = new QRadioButton(i18n("During as session"),bp);
      vp->addWidget(pcache[1]);

      pcache[2] = new QRadioButton(i18n("Never"),bp);
      vp->addWidget(pcache[2]);

      if (PCache > 2)
	PCache = 2;
      pcache[PCache]->setChecked(TRUE);
    }
    tab->addTab(bp,i18n("Package Cache"));

    {
      framem = new QGroupBox("", tab);
      QVBoxLayout* vf = new QVBoxLayout(framem,20,20);
      valid = new QCheckBox(i18n("Verify file list"), framem, "valid");
      vf->addWidget(valid,0,AlignLeft);

      valid->setChecked(verifyFL);
      pkgRead = new QCheckBox(i18n("Read information from all local package files"), framem, "pkgr");
      vf->addWidget(pkgRead,0,AlignLeft);
      pkgRead->setChecked(PkgRead);
    }
    tab->addTab(framem,i18n("misc"));

    tab->setCancelButton( i18n("Cancel") );
    tab->setApplyButton( i18n("Apply") );
    tab->setOkButton( i18n("OK") );

    connect( tab, SIGNAL(applyButtonPressed()), SLOT(apply_slot()) );
}

Options::~Options()
{
}

void Options::restore() 
{
  readSettings();
  tab->show();
}

void Options::apply_slot() 
{
  params->VerifyFL = valid->isChecked();
  params->PkgRead = pkgRead->isChecked();

  params->DCache = dc;
  params->PCache = pc;

  writeSettings();
}

void Options::PDCache(int r)
{
  dc = r;
}

void Options::PPCache(int r)
{
  pc = r;
}

void Options::readSettings()
{
  
  KConfig *config = kapp->config();

  config->setGroup("Kpackage");

  DCache = config->readNumEntry("Dir_Cache",1);
  params->DCache = DCache;
  dc = DCache;

  PCache = config->readNumEntry("Package_Cache",0);
  params->PCache = PCache;
  pc = PCache;

  verifyFL = config->readNumEntry("Verify_File_List",1);
  params->VerifyFL = verifyFL;

  PkgRead = config->readNumEntry("Read_Package_files",0);
  params->PkgRead = PkgRead;

}

void Options::writeSettings()
{
  
  KConfig *config = kapp->config();

  config->setGroup("Kpackage");

  config->writeEntry("Dir_Cache", dc);
  config->writeEntry("Package_Cache", pc);
  config->writeEntry("Verify_File_List", valid->isChecked());

  config->writeEntry("Read_Package_files", pkgRead->isChecked());
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

Params::Params()
{
}

Params::~Params()
{
}
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
