/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qlabel.h>
#include <qlayout.h>

#include <kglobal.h>
#include <klocale.h>

#include "drvspecinfobox.h"


DriveSpecInfoBox::DriveSpecInfoBox(DriveInfo *driveinfo, QWidget *parent, 
                                   const char *name) : QWidget(parent, name)
{
  QString  capstr, pathstr;
  ulong    blocks = driveinfo->blocks();
  
  capstr = i18n("%1 MB (%2 GB)")
    .arg(KGlobal::locale()->formatNumber(blocks/1024, 0))
    .arg(KGlobal::locale()->formatNumber((double) (blocks)/1048576, 1));
  pathstr = driveinfo->device();

  QLabel       *devlabel   = new QLabel(i18n("Device path:"),      this, "devlabel");
  QLabel       *devpath    = new QLabel(pathstr,                   this, "devpath");
  QLabel       *caplabel   = new QLabel(i18n("Storage capacity:"), this, "caplabel");
  QLabel       *capvalue   = new QLabel(capstr,                    this, "capvalue");

  QHBoxLayout  *toplayout  = new QHBoxLayout(this, -1, -1, "toplayout"); 
  QGridLayout  *gridlayout = new QGridLayout(toplayout, 3, 3);
  
  gridlayout->addColSpacing(1, 8);
  gridlayout->addRowSpacing(1, 4);

  gridlayout->addWidget(devlabel, 0, 0);
  gridlayout->addWidget(devpath,  0, 2);
  gridlayout->addWidget(caplabel, 2, 0);
  gridlayout->addWidget(capvalue, 2, 2);
  
  toplayout->addStretch(1);
}

