/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __FILEPARSER_H
#define __FILEPARSER_H

#include <stdio.h>
#include <sys/types.h>

#include <qstring.h>


class FileParser
{
  public:
  
    FileParser(const QString& fname);
    ~FileParser();
  
    bool     eof()		const { return _eof; }
    QString  nextLine();
    bool     reset();
    bool     traceBack();
    
  private:
  
    FILE    *_fhd;
    long    _filepos;
    bool    _eof;
};


#endif
