// $Id: misc.cpp,v 1.24 2000/08/05 12:25:23 bieker Exp $

#include "globals.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#ifdef HAVE_MNTENT_H
#include <mntent.h>
#endif

#ifdef HAVE_SYS_MNTENT_H
#include <sys/mntent.h>
#define BAD_GETMNTENT
#endif

#ifdef HAVE_SYS_MNTTAB_H
#include <sys/mnttab.h>
#endif

#include <qfile.h>

#include <kmessagebox.h>

#include "misc.h"
#include "kglobal_.h"

QString readentry(const QString &name, const QString def) {
  if (config->hasKey(name))
    return config->readEntry(name);
  else
    return def;
}

int readnumentry(const QString &name) {
  if (config->hasKey(name))
    return config->readNumEntry(name);
  else
    return (0);
}

void backup(const QString & name)
{
  QString tmp = name + QString::fromLatin1(KU_BACKUP_EXT);
  unlink(QFile::encodeName(tmp));

  if (rename(QFile::encodeName(name), QFile::encodeName(tmp)) == -1)
  {
    QString str;
    str = i18n("Can't create backup file for %1").arg(name);
    KMessageBox::error(0, tmp);
    exit (1);
  }
}

char *convertdate(char *buf, const long int base, const long int days) {
  time_t tmpd;

  tm *t;

  if ((base+days)<24855l) {
    if (days >0) {
      tmpd = (base+days)*24*60*60;
      t = localtime(&tmpd);

      sprintf(buf, "%d %d %d", t->tm_mday, t->tm_mon+1, t->tm_year+1900);
    } else {
      strcpy(buf, "Nothing");
    }
  } else {
    strcpy(buf, "Never");
  }

  return buf;
}

long today() {
  return (time(NULL)/(24*60*60));
}

QLabel *addLabel(QWidget *parent, const char *name, int x, int y, int w, int h, const QString & text) {

  QLabel *tmpLabel = new QLabel(parent, name);
  tmpLabel->setGeometry(x, y, w, h);
  tmpLabel->setAutoResize(TRUE);
  tmpLabel->setText(text);

  return (tmpLabel);
}

QLineEdit *addLineEdit(QWidget *parent, const char *name, int x, int y, int w, int h, const QString & text) {

  QLineEdit *tmpLE = new QLineEdit(parent, name);
  tmpLE->setGeometry(x, y, w, h);
  tmpLE->setText(text);

  return (tmpLE);
}

char *updateString(char *d, const char *t) {
  free(d);
  d = (char *)malloc(strlen(t)+1);  
  strcpy(d,t);
  return d;
}

int getValue(long int &data, const QString & text, const QString & msg) {
  bool ok;
  long int value = text.toLong(&ok);
  if (!ok) {
    KMessageBox::error(0, msg);
    return (-1);
  }
  data = value;

  return (0);
}

int getValue(int &data, const QString & text, const QString & msg) {
  bool ok;
  long int value = text.toLong(&ok);
  if (!ok) {
    KMessageBox::error(0, msg);
    return (-1);
  }
  data = value;

  return (0);
}

int getValue(unsigned int &data, const QString & text, const QString & msg) {
  bool ok;
  long int value = text.toLong(&ok);
  if (!ok) {
    KMessageBox::error(0, msg);
    return (-1);
  }
  data = value;

  return (0);
}

int copyFile(const QString & from, const QString & to) {
  QFile fi;
  QFile fo;
  char buf[4096];

#ifdef _KU_DEBUG
  printf("%s -> %s\n", from.local8Bit().data(), to.local8Bit().data());
#endif
  
  fi.setName(from);
  fo.setName(to);
  
  if (!fi.exists()) {
    err->addMsg(i18n("File %1 does not exist.").arg(from));
    return (-1);
  }

  if (!fi.open(IO_ReadOnly)) {
    err->addMsg(i18n("Can not open file %1 for reading.").arg(from));
    return (-1);
  }
    
  if (!fo.open(IO_Raw | IO_WriteOnly | IO_Truncate)) {
    err->addMsg(i18n("Can not open file %1 for writing.").arg(to));
    return (-1);
  }
  
  while (!fi.atEnd()) {
    int len = fi.readBlock(buf, 65536);
    fo.writeBlock(buf, len);
  }
  
  fi.close();
  fo.close();
    
  return (0);
}
