/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __containerarea_h__
#define __containerarea_h__

#include <qptrlist.h>
#include <qtimer.h>

#include "global.h"
#include "panner.h"
#include "container_base.h"

class KConfig;
class DragIndicator;
class PanelContainer;

class ContainerArea : public Panner
{
    Q_OBJECT

public:
    ContainerArea( KConfig* config, QWidget* parent, const char* name = 0 );
    ~ContainerArea();

public:
    int position() const;
    Direction popupDirection() const;

    void initialize( PanelContainer* panel, bool useDefaultConfig );

    void addKMenuButton();
    void addDesktopButton();
    void addWindowListButton();
    void addBookmarksButton();
    void addRecentDocumentsButton();
    void addServiceButton(const QString& desktopFile);
    void addURLButton(const QString &url);
    void addBrowserButton(const QString &startDir, const QString& icon = QString("kdisknav"));
    void addServiceMenuButton(const QString &name, const QString& relPath);
    void addNonKDEAppButton(const QString &filePath, const QString &icon,
		      const QString &cmdLine, bool inTerm);
    void addKonsoleButton();
    void addExtensionButton(const QString& desktopFile);

    void addApplet( const QString& desktopFile );

    void configure();

    bool inMoveOperation() const { return _movingAC; }
    int minimumUsedSpace( Orientation, int width, int height ) const;

    QPtrList<BaseContainer> containers( const QString& type ) const;

    void addContainer(BaseContainer* a);
    void removeContainer(BaseContainer *a);
    void removeAllContainers();

public slots:
    void setOrientation(Orientation o);
    void setPosition(Position p);
    void setAlignment(Alignment a);
    void slotLayoutChildren();
    void slotSaveContainerConfig();

signals:
    void sizeHintChanged();

protected slots:
    void startContainerMove(BaseContainer *a);
    void stopContainerMove(BaseContainer *a);

protected:
    void layoutChildren();

    BaseContainer* coversContainer(BaseContainer *a, bool strict);

    void updateContainerList();
    int relativeContainerPos(BaseContainer*) const;
    int totalFreeSpace() const;

    void mouseMoveEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);

    void dragEnterEvent(QDragEnterEvent*);
    void dragMoveEvent(QDragMoveEvent*);
    void dragLeaveEvent(QDragLeaveEvent*);
    void dropEvent(QDropEvent*);

    virtual void resizeEvent(QResizeEvent *);

    void setUniqueId(BaseContainer* a);
    void moveToFirstFreePosition(BaseContainer* a);

    void disableStretch();
    void restoreStretch();

    void saveContainerConfig(bool layoutOnly = false);
    void loadContainerConfig();
    void defaultContainerConfig( PanelContainer* panel, bool useDefaultConfig );

    void moveContainerSwitch(BaseContainer* a, int distance);
    int moveContainerPush(BaseContainer* a, int distance);

    int moveContainerPushRecursive(QPtrListIterator<BaseContainer> it, int distanceRequest);

    QRect availableSpaceFollowing(BaseContainer*);
    void moveDragIndicator(int pos);

    void setBackgroundTheme();

    void scrollTo(BaseContainer*);

protected slots:
    void embeddedWindowDestroyed();
    void slotRemoveContainer(BaseContainer*);
    void autoScroll();

private:
    QPtrList<BaseContainer> _containers;

    bool	    _block_relayout;
    bool	    _movingAC;
    BaseContainer*  _moveAC;
    Position	    _pos;
    KConfig*	    _config;
    DragIndicator*  _dragIndicator;
    BaseContainer*  _dragMoveAC;
    QPoint	    _dragMoveOffset;
    QTimer          _autoScrollTimer;
};

class DragIndicator : public QWidget
{
    Q_OBJECT

public:
    DragIndicator(QWidget* parent = 0, const char* name = 0)
	: QWidget(parent, name) {;}
    ~DragIndicator() {;}

    QSize preferredSize() const { return _preferredSize; }
    void setPreferredSize(const QSize& size) { _preferredSize = size; }

protected:
    void paintEvent(QPaintEvent*);
    void mousePressEvent(QMouseEvent*);

private:
    QSize _preferredSize;
};

#endif

