/***************************************************************************
                          kcontroladdedit.cpp  -  description
                             -------------------
    begin                : Sun May 27 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcontroladdedit.h"
#include "kcontroladdedit.moc"

#include <klocale.h>
#include <kstandarddirs.h>
#include <kconfig.h>

#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>

kcontroladdedit::kcontroladdedit(QWidget *parent, const char *name, bool modal, WFlags f) : KWizard(parent, name, modal, f)
{
	setPageQuestion();
	setPageAnswer();
	configRead();
}

kcontroladdedit::~kcontroladdedit()
{
}

/** Init KEDUCA pointer and EditMode */
void kcontroladdedit::init(FileRead *KEDUCAPTR, bool edit)
{
	KEDUCA = KEDUCAPTR;
	editMode = edit;

	if( editMode )
	{
	this->setCaption(i18n("Modify Question"));
	fillPage();
	}else{
  this->setCaption(i18n("Add Questions"));
	slotQuestionType( 0 );
	}
}

/** Fill page of current record */
void kcontroladdedit::fillPage()
{
	question_text->setText( 		KEDUCA->getQuestion( FileRead::QF_text ) 		);
	if( !KEDUCA->getQuestion( FileRead::QF_picture ).isEmpty() )
		{
		question_preview1->setPixmap(KEDUCA->getQuestion(FileRead::QF_picture));
		question_preview2->setPixmap(KEDUCA->getQuestion(FileRead::QF_picture));
		question_picture->setURL(	KEDUCA->getQuestion( FileRead::QF_picture ) );
		}
	question_type->setCurrentItem( KEDUCA->getQuestionInt( FileRead::QF_type )-1 );
	slotQuestionType( question_type->currentItem() );
	question_point->setValue( 		KEDUCA->getQuestionInt( FileRead::QF_points )	);
	question_tip->setText( 			KEDUCA->getQuestion( FileRead::QF_tip ) 		);
	question_explain->setText( 	KEDUCA->getQuestion( FileRead::QF_explain ) );
	question_time->setValue( 		KEDUCA->getQuestionInt( FileRead::QF_time )	);

	KEDUCA->recordAnswerFirst();
	while( !KEDUCA->recordAnswerEOF() )
	{
		tmpStruct tmp;
		tmp.text = KEDUCA->getAnswer( FileRead::AF_text );
		tmp.result = KEDUCA->getAnswerValue();
		tmp.points = KEDUCA->getAnswerPoints();
		Answer_copy.append( tmp );
		KEDUCA->recordAnswerNext();
	};
	refreshAnswer_list();
}

/** Refresh klistview of answers */
void kcontroladdedit::refreshAnswer_list()
{
	List_answers->clear();

	QValueListIterator<tmpStruct> it;
	for( it = Answer_copy.begin(); it != Answer_copy.end(); ++it )
		{
		if( (*it).result )
			(void)new QListViewItem( List_answers, List_answers->lastItem(), (*it).text, i18n("True"), QString().setNum( (*it).points) );
			else
			(void)new QListViewItem( List_answers, List_answers->lastItem(), (*it).text, i18n("False"), QString().setNum((*it).points) );
		}
}
/** Button insert */
void kcontroladdedit::slot_ButtonAdd()
{
	if( !answer_text->text().isEmpty() )
		{
		tmpStruct tmp;
		tmp.text = answer_text->text();
		if( answer_value->currentItem() == 1 )
			{
			tmp.result = true;
			(void)new QListViewItem( List_answers, List_answers->lastItem(), answer_text->text(), i18n("True"), QString().setNum(answer_points->value()) );
			} else {
			tmp.result = false;
			(void)new QListViewItem( List_answers, List_answers->lastItem(), answer_text->text(), i18n("False"), QString().setNum(answer_points->value()) );
			}
		tmp.points = answer_points->value();
		Answer_copy.append( tmp );

		answer_text->setText("");
		answer_value->setCurrentItem( 0 );
		answer_points->setValue(0);
		answer_text->setFocus();
		}
}

/** Remove answer */
void kcontroladdedit::slot_ButtonRemove()
{
	QListViewItem *item = List_answers->currentItem();

	if( !item ) return;

	QValueListIterator<tmpStruct> it;
	for( it = Answer_copy.begin(); it != Answer_copy.end(); ++it )
		{
		if( (*it).text == item->text(0) ) { Answer_copy.remove( it ); break;	}
		}
	List_answers->removeItem( List_answers->currentItem() );
}

/** Button Up */
void kcontroladdedit::slot_ButtonUp()
{
	QListViewItem *item = List_answers->currentItem();

	if( !item ) return;
	if( List_answers->itemPos(item) < 1 ) return;

	QString textTMP = item->text(0);
	List_answers->clearSelection();

	QValueListIterator<tmpStruct> it;
	for( it = Answer_copy.begin(); it != Answer_copy.end(); ++it )
		{
		if( (*it).text == textTMP )
			{
			bool resultTMP;
			int pointsTMP;
			QString textNEXT;
			bool resultNEXT;
			int pointsNEXT;

			resultTMP = (*it).result;
			pointsTMP = (*it).points;
			--it;
			textNEXT = (*it).text;
			resultNEXT = (*it).result;
			pointsNEXT = (*it).points;
			(*it).text = textTMP;
			(*it).result = resultTMP;
			(*it).points = pointsTMP;
			++it;
			(*it).text = textNEXT;
			(*it).result = resultNEXT;
			(*it).points = pointsNEXT;
			break;
			}
		}
	refreshAnswer_list();
}

/** Button Down */
void kcontroladdedit::slot_ButtonDown()
{
	QListViewItem *item = List_answers->currentItem();

	if( !item ) return;
	if( item == List_answers->lastItem() ) return;

	QString textTMP = item->text(0);
	List_answers->clearSelection();

	QValueListIterator<tmpStruct> it;
	for( it = Answer_copy.begin(); it != Answer_copy.end(); ++it )
		{
		if( (*it).text == textTMP )
			{
			bool resultTMP;
			int pointsTMP;
			QString textNEXT;
			bool resultNEXT;
			bool pointsNEXT;

			resultTMP = (*it).result;
			pointsTMP = (*it).points;
			++it;
			textNEXT = (*it).text;
			resultNEXT = (*it).result;
			pointsNEXT = (*it).points;
			(*it).text = textTMP;
			(*it).result = resultTMP;
			(*it).points = pointsTMP;
			--it;
			(*it).text = textNEXT;
			(*it).result = resultNEXT;
			(*it).points = pointsNEXT;
			break;
			}
		}
	refreshAnswer_list();
}

/** Accept changes */
void kcontroladdedit::accept()
{
if( !editMode )
	KEDUCA->insertQuestion();

	addQuestion();
	configWrite();
	this->done( QDialog::Accepted );
}

/** Add question with form data */
void kcontroladdedit::addQuestion()
{
	KEDUCA->setQuestion( FileRead::QF_text, question_text->text() );
	KEDUCA->setQuestion( FileRead::QF_type, question_type->currentItem()+1 );
	KEDUCA->setQuestion( FileRead::QF_picture, question_picture->url() );	
	KEDUCA->setQuestion( FileRead::QF_points, question_point->value() );
	KEDUCA->setQuestion( FileRead::QF_time, question_time->value() );
	KEDUCA->setQuestion( FileRead::QF_tip, question_tip->text() );
	KEDUCA->setQuestion( FileRead::QF_explain, question_explain->text() );

	KEDUCA->clearAnswers();
	QValueListIterator<tmpStruct> it;
	int i=0;
	for( it = Answer_copy.begin(); it != Answer_copy.end(); ++it )
		{
		KEDUCA->setAnswer( (*it).text, (*it).result, (*it).points );
		i++;
		}
}
/** Read config settings */
void kcontroladdedit::configRead()
{
  KConfig *config = KGlobal::config();
	config->setGroup("AddModify Window");
	QSize defaultSize(500,400);
	this->resize( config->readSizeEntry("Geometry", &defaultSize ) );
}

/** Write config settings */
void kcontroladdedit::configWrite()
{
  KConfig *config = KGlobal::config();
	config->setGroup("AddModify Window");
	config->writeEntry("Geometry", this->size() );
	config->sync();
}

/** Set page question */
void kcontroladdedit::setPageQuestion()
{
	page_question = new QWidget(this);
	QHBoxLayout *page_questionLayout = new QHBoxLayout( page_question );
	page_questionLayout->setSpacing( 6 );
	page_questionLayout->setMargin( 0 );

	QFrame *Frame14 = new QFrame( page_question, "Frame14" );
	Frame14->setMinimumSize( QSize( 125, 0 ) );
	Frame14->setMaximumSize( QSize( 125, 32767 ) );
	Frame14->setFrameShape( QFrame::Box );
	Frame14->setFrameShadow( QFrame::Plain );
	Frame14->setBackgroundPixmap( QPixmap(locate("appdata","pics/bk_frame.png") ) );
	QVBoxLayout *Frame14Layout = new QVBoxLayout( Frame14 );
	Frame14Layout->setSpacing( 6 );
	Frame14Layout->setMargin( 11 );

	question_preview1 = new QLabel( Frame14, "question_preview1" );
	question_preview1->setMinimumSize( QSize( 100, 100 ) );
	question_preview1->setMaximumSize( QSize( 100, 100 ) );
	question_preview1->setPalette( QPalette( QColor(255, 255, 255) ) );
	question_preview1->setFrameShape( QFrame::Box );
	question_preview1->setFrameShadow( QFrame::Plain );
	question_preview1->setScaledContents( TRUE );
	Frame14Layout->addWidget( question_preview1 );
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
	Frame14Layout->addItem( spacer );

	QLabel *TextLabel2 = new QLabel( Frame14, "TextLabel2" );
	TextLabel2->setText( i18n( "<p><b>Question</b></p><hr><p>Only the question and type is required.</p>" ) );
	TextLabel2->setBackgroundPixmap( QPixmap(locate("appdata","pics/bk_frame.png") ) );
	Frame14Layout->addWidget( TextLabel2 );
	QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
	Frame14Layout->addItem( spacer_2 );
	page_questionLayout->addWidget( Frame14 );

    QFrame *Frame15 = new QFrame( page_question, "Frame15" );
    Frame15->setFrameShape( QFrame::Box );
    Frame15->setFrameShadow( QFrame::Sunken );
    QGridLayout *Frame15Layout = new QGridLayout( Frame15 );
    Frame15Layout->setSpacing( 6 );
    Frame15Layout->setMargin( 6 );

    QLabel *TextLabel3 = new QLabel( Frame15, "TextLabel3" );
    TextLabel3->setText( i18n( "Question :" ) );
    TextLabel3->setAlignment( int( QLabel::AlignTop | QLabel::AlignRight ) );
    Frame15Layout->addWidget( TextLabel3, 0, 0 );

    QLabel *TextLabel4 = new QLabel( Frame15, "TextLabel4" );
    TextLabel4->setText( i18n( "Picture :" ) );
    TextLabel4->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	Frame15Layout->addWidget( TextLabel4, 1, 0 );

	question_text = new QMultiLineEdit( Frame15, "question_text" );
	question_text->setWordWrap( QMultiLineEdit::WidgetWidth );
	connect( question_text, SIGNAL( textChanged() ), this, SLOT( slotDataChanged() ) );
	Frame15Layout->addWidget( question_text, 0, 1 );

    question_picture = new KURLRequester( Frame15, "question_picture" );
		connect( question_picture, SIGNAL( textChanged( const QString & ) ), this, SLOT( slotPreview( const QString & ) ) );
    Frame15Layout->addWidget( question_picture, 1, 1 );

    QLabel *TextLabel5 = new QLabel( Frame15, "TextLabel5" );
    TextLabel5->setText( i18n( "Type :" ) );
    TextLabel5->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    Frame15Layout->addWidget( TextLabel5, 2, 0 );

    QHBoxLayout *Layout12 = new QHBoxLayout;
    Layout12->setSpacing( 6 );
    Layout12->setMargin( 0 );

    question_type = new KComboBox( FALSE, Frame15, "question_type" );
    question_type->insertItem( i18n("Test") );
    question_type->insertItem( i18n("Test with Question Points") );
    question_type->insertItem( i18n("Test with Answers Points") );
	connect( question_type, SIGNAL( activated(int) ), this, SLOT( slotQuestionType(int) ) );
    Layout12->addWidget( question_type );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout12->addItem( spacer_3 );

    Frame15Layout->addLayout( Layout12, 2, 1 );

    QLabel *TextLabel61 = new QLabel( Frame15, "TextLabel61" );
    TextLabel61->setText( i18n( "Point :" ) );
    TextLabel61->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    Frame15Layout->addWidget( TextLabel61, 3, 0 );

    QHBoxLayout *Layout131 = new QHBoxLayout;
    Layout131->setSpacing( 6 );
    Layout131->setMargin( 0 );
    question_point = new KIntNumInput( Frame15, "question_point" );
    Layout131->addWidget( question_point );
    QSpacerItem* spacer_41 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout131->addItem( spacer_41 );
    Frame15Layout->addLayout( Layout131, 3, 1 );

    QLabel *TextLabel6 = new QLabel( Frame15, "TextLabel6" );
    TextLabel6->setText( i18n( "Time :" ) );
    TextLabel6->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    Frame15Layout->addWidget( TextLabel6, 4, 0 );

    QHBoxLayout *Layout13 = new QHBoxLayout;
    Layout13->setSpacing( 6 );
    Layout13->setMargin( 0 );
    question_time = new KIntNumInput( Frame15, "question_time" );
    Layout13->addWidget( question_time );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout13->addItem( spacer_4 );
    Frame15Layout->addLayout( Layout13, 4, 1 );

    QLabel *TextLabel7 = new QLabel( Frame15, "TextLabel7" );
    TextLabel7->setText( i18n( "Tip :" ) );
    TextLabel7->setAlignment( int( QLabel::AlignTop | QLabel::AlignRight ) );
    Frame15Layout->addWidget( TextLabel7, 5, 0 );
    question_tip = new QLineEdit( Frame15, "question_tip" );
    Frame15Layout->addWidget( question_tip, 5, 1 );

    QLabel *TextLabel8 = new QLabel( Frame15, "TextLabel8" );
    TextLabel8->setText( i18n( "Explain :" ) );
    TextLabel8->setAlignment( int( QLabel::AlignTop | QLabel::AlignRight ) );
    Frame15Layout->addWidget( TextLabel8, 6, 0 );

    question_explain = new QMultiLineEdit( Frame15, "question_explain" );
    question_explain->setWordWrap( QMultiLineEdit::WidgetWidth );
    Frame15Layout->addWidget( question_explain, 6, 1 );

    page_questionLayout->addWidget( Frame15 );
    this->addPage( page_question, i18n( "Question" ) );
	this->setHelpEnabled ( page_question, false );
	this->setNextEnabled( page_question, false );
}

/** Set answer page */
void kcontroladdedit::setPageAnswer()
{
    page_answer = new QWidget( this, "page_answer" );
    QHBoxLayout *page_answerLayout = new QHBoxLayout( page_answer );
    page_answerLayout->setSpacing( 6 );
    page_answerLayout->setMargin( 0 );

    QFrame *Frame14_2 = new QFrame( page_answer, "Frame14_2" );
    Frame14_2->setMinimumSize( QSize( 125, 0 ) );
    Frame14_2->setMaximumSize( QSize( 125, 32767 ) );
    Frame14_2->setFrameShape( QFrame::Box );
    Frame14_2->setFrameShadow( QFrame::Plain );
		Frame14_2->setBackgroundPixmap( QPixmap(locate("appdata","pics/bk_frame.png") ) );
    QVBoxLayout *Frame14_2Layout = new QVBoxLayout( Frame14_2 );
    Frame14_2Layout->setSpacing( 6 );
    Frame14_2Layout->setMargin( 11 );

    question_preview2 = new QLabel( Frame14_2, "question_preview2" );
    question_preview2->setMinimumSize( QSize( 100, 100 ) );
    question_preview2->setMaximumSize( QSize( 100, 100 ) );
		question_preview2->setPalette( QPalette( QColor(255, 255, 255) ) );
		question_preview2->setFrameShape( QFrame::Box );
    question_preview2->setFrameShadow( QFrame::Plain );
    question_preview2->setScaledContents( TRUE );
    Frame14_2Layout->addWidget( question_preview2 );
    QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Frame14_2Layout->addItem( spacer_5 );

    QLabel *TextLabel2_2 = new QLabel( Frame14_2, "TextLabel2_2" );
    TextLabel2_2->setText( i18n( "<p><b>Answers</b></p><hr><p>Only the Answer and Value is required.</p>" ) );
		TextLabel2_2->setBackgroundPixmap( QPixmap(locate("appdata","pics/bk_frame.png") ) );
    Frame14_2Layout->addWidget( TextLabel2_2 );
    QSpacerItem* spacer_6 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Frame14_2Layout->addItem( spacer_6 );
    page_answerLayout->addWidget( Frame14_2 );

    QFrame *Frame17 = new QFrame( page_answer, "Frame17" );
    Frame17->setFrameShape( QFrame::Box );
    Frame17->setFrameShadow( QFrame::Sunken );
    QVBoxLayout *Frame17Layout = new QVBoxLayout( Frame17 );
    Frame17Layout->setSpacing( 6 );
    Frame17Layout->setMargin( 6 );

    QHBoxLayout *Layout16 = new QHBoxLayout;
    Layout16->setSpacing( 4 );
    Layout16->setMargin( 0 );

    List_answers = new KListView( Frame17, "List_answers" );
    List_answers->addColumn( i18n( "Answer" ) );
    List_answers->addColumn( i18n( "Value" ) );
    List_answers->addColumn( i18n( "Points" ) );
		List_answers->setAllColumnsShowFocus ( true ),
		List_answers->setSorting(-1);
		List_answers->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)5, List_answers->sizePolicy().hasHeightForWidth() ) );
    Layout16->addWidget( List_answers );

    QVBoxLayout *Layout15 = new QVBoxLayout;
    Layout15->setSpacing( 6 );
    Layout15->setMargin( 0 );

    Button_remove = new QPushButton( Frame17, "Button_remove" );
    Button_remove->setText( i18n( "&Remove" ) );
		connect( Button_remove, SIGNAL(clicked()), this, SLOT(slot_ButtonRemove()) );
    Layout15->addWidget( Button_remove );
    QSpacerItem* spacer_7 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Layout15->addItem( spacer_7 );

    QGridLayout *Layout14 = new QGridLayout;
    Layout14->setSpacing( 6 );
    Layout14->setMargin( 0 );
    QSpacerItem* spacer_8 = new QSpacerItem( 20, 20, QSizePolicy::Preferred, QSizePolicy::Minimum );
    Layout14->addItem( spacer_8, 0, 1 );
    QSpacerItem* spacer_9 = new QSpacerItem( 20, 20, QSizePolicy::Preferred, QSizePolicy::Minimum );
    Layout14->addItem( spacer_9, 1, 1 );

    Button_down = new QPushButton( Frame17, "Button_down" );
    Button_down->setPixmap( locate( "icon", "hicolor/22x22/actions/down.png" ) );
		connect( Button_down, SIGNAL( clicked() ), this, SLOT( slot_ButtonDown() ) );

    Layout14->addWidget( Button_down, 1, 0 );

    Button_up = new QPushButton( Frame17, "Button_up" );
    Button_up->setPixmap( locate( "icon", "hicolor/22x22/actions/up.png" ) );
		connect( Button_up, SIGNAL( clicked() ), this, SLOT( slot_ButtonUp() ) );

    Layout14->addWidget( Button_up, 0, 0 );
    Layout15->addLayout( Layout14 );
    Layout16->addLayout( Layout15 );
    Frame17Layout->addLayout( Layout16 );

    QFrame *Line3 = new QFrame( Frame17, "Line3" );
    Line3->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    Frame17Layout->addWidget( Line3 );

    QGridLayout *Layout20 = new QGridLayout;
    Layout20->setSpacing( 4 );
    Layout20->setMargin( 0 );
    QSpacerItem* spacer_10 = new QSpacerItem( 20, 20, QSizePolicy::Preferred, QSizePolicy::Minimum );
    Layout20->addItem( spacer_10, 3, 0 );

    QLabel *TextLabel11 = new QLabel( Frame17, "TextLabel11" );
    TextLabel11->setText( i18n( "Points :" ) );
    TextLabel11->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    Layout20->addWidget( TextLabel11, 2, 0 );

    Button_insert = new QPushButton( Frame17, "Button_insert" );
		connect( Button_insert, SIGNAL(clicked()), this, SLOT(slot_ButtonAdd()) );
    Button_insert->setText( i18n( "Insert" ) );

    Layout20->addWidget( Button_insert, 3, 1 );

    answer_text = new QMultiLineEdit( Frame17, "answer_text" );
    answer_text->setWordWrap( QMultiLineEdit::WidgetWidth );
    Layout20->addWidget( answer_text, 0, 1 );

    QHBoxLayout *Layout19 = new QHBoxLayout;
    Layout19->setSpacing( 6 );
    Layout19->setMargin( 0 );

    answer_points = new KIntNumInput( Frame17, "answer_points" );
    Layout19->addWidget( answer_points );
    QSpacerItem* spacer_11 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout19->addItem( spacer_11 );

    Layout20->addLayout( Layout19, 2, 1 );

    QHBoxLayout *Layout17 = new QHBoxLayout;
    Layout17->setSpacing( 6 );
    Layout17->setMargin( 0 );

    answer_value = new KComboBox( FALSE, Frame17, "answer_value" );
    answer_value->insertItem( i18n( "False" ) );
    answer_value->insertItem( i18n( "True" ) );
    Layout17->addWidget( answer_value );
    QSpacerItem* spacer_12 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout17->addItem( spacer_12 );

    Layout20->addLayout( Layout17, 1, 1 );

    QLabel *TextLabel10 = new QLabel( Frame17, "TextLabel10" );
    TextLabel10->setText( i18n( "Value :" ) );
    TextLabel10->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    Layout20->addWidget( TextLabel10, 1, 0 );

    QLabel *TextLabel9 = new QLabel( Frame17, "TextLabel9" );
    TextLabel9->setText( i18n( "Answer :" ) );
    TextLabel9->setAlignment( int( QLabel::AlignTop | QLabel::AlignRight ) );

    Layout20->addWidget( TextLabel9, 0, 0 );
    Frame17Layout->addLayout( Layout20 );
    page_answerLayout->addWidget( Frame17 );
    this->addPage( page_answer, i18n( "Answers" ) );
		this->setHelpEnabled ( page_answer, false );
		this->setFinishEnabled( page_answer, true );
}

/** Question data changed */
void kcontroladdedit::slotDataChanged()
{
	if( page_question == this->currentPage() )
		{
		if( question_text->text().isEmpty() )
			{
			nextButton()->setEnabled( false );
			}
			else
			{
			nextButton()->setEnabled( true );
      }
		}
}

/** Preview image */
void kcontroladdedit::slotPreview( const QString &text)
{
	if( text.isEmpty() ) { question_preview1->setText(""); question_preview2->setText(""); return; }

	question_preview1->setPixmap( QPixmap( text ) );
	question_preview2->setPixmap( QPixmap( text ) );
}

/** show current Page */
void kcontroladdedit::showPage(QWidget *page)
{
    QWizard::showPage(page);

    if ( page == page_question ) {
        slotDataChanged();
        question_text->setFocus();
    } else if ( page == page_answer ) {
        answer_text->setFocus();
    }
}

/** Change question type */
void kcontroladdedit::slotQuestionType( int index )
{
	switch( index+1 )
	{
	case 1:
		question_point->setEnabled( false );
		answer_points->setEnabled( false );
		question_point->setValue(0);
		answer_points->setValue(0);
		break;
	case 2:
		question_point->setEnabled( true );
		answer_points->setEnabled( false );
		answer_points->setValue(0);
		break;
	case 3:
		question_point->setEnabled( false );
		answer_points->setEnabled( true );
		question_point->setValue(0);
		break;
	default:
		break;
	}
}
