/***************************************************************************
                          keducaview.cpp  -  description
                             -------------------
    begin                : Thu May 24 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "keducaview.h"
#include "keducaview.moc"

#include <klocale.h>
#include <kstandarddirs.h>
#include <kconfig.h>
#include <kaction.h>
#include <kstdaction.h>

keducaview::keducaview(QWidget *parent, const char *name ) : QWidget(parent,name)
{
}

keducaview::~keducaview()
{
	delete question_text;
	delete ButtonGroup;
	delete split;
	delete ButtonNext;
	delete ViewResults;
	delete KEDUCA;
}

/** Init graphical interface */
void keducaview::init()
{
	QVBoxLayout *vbox = new QVBoxLayout( this );
	vbox->setSpacing( 6 );
	vbox->setMargin( 11 );

	vbox2 = new QVBoxLayout( this );
	split = new QSplitter( this );
	split->setOrientation( QSplitter::Vertical );
	question_text = new KQuestion( split, "kquestion" );
	ButtonGroup = new KGroupEduca( split, "ButtonGroup" );
	ButtonGroup->setRadioButtonExclusive( TRUE );
	vbox2->addWidget( split );
	vbox->addLayout( vbox2 );

	ViewResults = new QTextView(this);
	ViewResults->hide();
	vbox->addWidget( ViewResults );

	ButtonNext = new QPushButton( this, "ButtonNext" );
	ButtonNext->setText( i18n("&Next >>") );
	ButtonNext->setAutoRepeat( FALSE );
	ButtonNext->setToggleButton( FALSE );
	ButtonNext->setDefault( TRUE );
	connect( ButtonNext, SIGNAL( clicked() ), SLOT( slot_ButtonNext() ) );
	vbox->addWidget( ButtonNext );
}

/** Button Next action */
void keducaview::slot_ButtonNext()
{
	if( question_text->isVisible() )	setResults();
	ButtonGroup->clearAnswers();

	if( !showResultFinish && question_text->isVisible() )
	{
		showResults( currentResults );
	}
	else
	{
		KEDUCA->recordNext();
		if( !showRecord() )
		{
			configWrite();
			ButtonNext->hide();
			showResults( results );
		}
	}
}

/** Show record, returns false if there is no record to show. */
bool keducaview::showRecord()
{
	if( KEDUCA->recordEOF() ) return false;

	if( ViewResults->isVisible() )
	{
		ViewResults->hide();
		split->show();
	}

	KEDUCA_record++;
	bool MultiAnswer = KEDUCA->isMultiAnswer();

	question_text->setPixmap( KEDUCA->getPicture() );
	question_text->setText( "<b>Question "+ QString().setNum(KEDUCA_record) + " </b><hr/><table><tr><td>" + KEDUCA->getQuestion( FileRead::QF_text ) + "</td></tr></table><" );

	if( MultiAnswer )
		ButtonGroup->setType( KGroupEduca::Check );
	else
		ButtonGroup->setType( KGroupEduca::Radio );

	KEDUCA->recordAnswerFirst();
	while( !KEDUCA->recordAnswerEOF() )
	{
	if( !KEDUCA->getAnswer(FileRead::AF_text).isEmpty() )	ButtonGroup->insertAnswer( KEDUCA->getAnswer(FileRead::AF_text) );
	KEDUCA->recordAnswerNext();
	};

	return true;
}

/** Show results */
void keducaview::showResults(const QString &text)
{
	split->hide();
	ViewResults->setText( text );
	ViewResults->show();
}

/** Set results */
void keducaview::setResults()
{
  bool isCorrect = true;
	int nAnswer = 0;
	QString YourAnswer = "";
	QString CorrectAnswer = "";

	KEDUCA->recordAnswerFirst();
	while( !KEDUCA->recordAnswerEOF() )
	{
	QString answertext = KEDUCA->getAnswer( FileRead::AF_text );
  if( !answertext.isEmpty() )
		{
			if(ButtonGroup->isChecked(nAnswer) != KEDUCA->getAnswerValue())
				{
				isCorrect=false;
				if(ButtonGroup->isChecked(nAnswer)) YourAnswer += "<LI><FONT COLOR=#b84747><B>" + answertext + "</B></FONT></LI>";
	      if(KEDUCA->getAnswerValue()) CorrectAnswer += "<LI><FONT COLOR=#006b6b><B>" + answertext + "</B></FONT></LI>";
				}
				else
				{
				if(ButtonGroup->isChecked(nAnswer)) YourAnswer += "<LI><B>" + answertext + "</B></LI>";
	      if(KEDUCA->getAnswerValue()) CorrectAnswer += "<LI><B>" + answertext + "</B></LI>";
				}
    }
		KEDUCA->recordAnswerNext();
		nAnswer++;
	}

	currentResults = "<TABLE WIDTH=100% BORDER=0 CELLPADDING=0 CELLSPACING=0><COL WIDTH=244*><COL WIDTH=12*><THEAD><TR>";

	if( isCorrect)
	{
		Correct_Answer++;
		currentResults += "<TH WIDTH=95% BGCOLOR=#006b6b>";
		} else {
		Incorrect_Answer++;
		currentResults += "<TH WIDTH=95% BGCOLOR=#b84747>";
	}

  currentResults += "<P ALIGN=LEFT><FONT COLOR=#ffffff SIZE=4> ";
	currentResults += KEDUCA->getQuestion( FileRead::QF_text );
  currentResults += "</FONT></TH>";

	if( isCorrect )
		currentResults += "<TH WIDTH=5% BGCOLOR=#006b6b SDVAL=1 SDNUM=1034;>";
		else
		currentResults += "<TH WIDTH=5% BGCOLOR=#b84747 SDVAL=1 SDNUM=1034;>";

	currentResults += "<P><FONT COLOR=#ffffff>";
	currentResults += QString().setNum( KEDUCA_record );
	currentResults += "</FONT></TH>";
	currentResults += "</TR></THEAD><TBODY>";

	currentResults += "<TR><TD COLSPAN=2 WIDTH=100% BGCOLOR=#eeeeee ><P>";
	if( isCorrect )
		currentResults += i18n( "The Answer is :");
		else
		currentResults += i18n( "The Correct Answer is :");
	currentResults += "</TD></TR>";

	currentResults += "<TR><TD COLSPAN=2 WIDTH=100% BGCOLOR=#eeeeee><UL>";
	currentResults += CorrectAnswer;
	currentResults += "</UL></TD></TR>";

	if( !isCorrect )
		{
		currentResults += "<TR><TD COLSPAN=2 WIDTH=100% BGCOLOR=#eeeeee><P>";
		currentResults += i18n( "Your Answer was :");
		currentResults += "</TD></TR>";
		currentResults += "<TR><TD COLSPAN=2 WIDTH=100% BGCOLOR=#eeeeee><UL>";
		currentResults += YourAnswer;
		currentResults += "</UL></TD></TR>";
    }

	currentResults += "	</TBODY></TABLE><P></P>";

	results += currentResults;
}

/** Open url */
bool keducaview::openURL( const KURL &url)
{
	KEDUCA = new FileRead();
	if( !KEDUCA->openFile( url.url() ) ) return false;
	KEDUCA->recordFirst();
	KEDUCA->recordAnswerFirst();

	Correct_Answer = 0;
	Incorrect_Answer = 0;
	KEDUCA_record = 0;
	results = "";

	init();
	configRead();
	showRecord();

	return true;
}

/** Read settings */
void keducaview::configRead()
{
	KConfig *config = KGlobal::config();

	config->setGroup( "keducaview" );
	split->setSizes( config->readIntListEntry("Splitter_size") );

	config->setGroup("Options");
	showResultFinish = config->readBoolEntry("ResultFinish", true );
}

/** Write settings */
void keducaview::configWrite()
{
	KConfig *config = KGlobal::config();
	config->setGroup( "keducaview" );
	config->writeEntry("Splitter_size", split->sizes() );
	config->sync();
}
