/***************************************************************************
                          point.cpp  -  description
                             -------------------
    begin                : Sat Feb 19 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "point.h"

Point::Point( QPoint *pt ): GeoPoint( pt )
{
	identificator = "Point";
	ID = ID_point;

	isMovable = true;
	acceptsQPoint = true;
}

Point::~Point()
{
}

void Point::move( QPoint *pt )
{
	//	I will take this point as my new coordinates.
	coords.set( *pt );
	coords += moveOffset;

 	if ( parents.count() > 0 )
 	{
 		position = parents.first()->positionMe( coords );
 	}

	if ( isTrace )
	{
		trace.append( new QRect( surroundingRect ) );
	}

	//	Calculate new rectangle around point.
	if ( ( size % 2 ) == 0 )
		size += 1;

	int x = coords.getI_X() - ( ( size - 1 ) / 2 );
	int y = coords.getI_Y() - ( ( size - 1 ) / 2 );

	//  Set rectangle.
	surroundingRect = QRect ( x, y, size, size );
}

void Point::move()
{
	if ( isTrace )
	{
		trace.append( new QRect( surroundingRect ) );
	}

	if ( !initComplete )
	{
		if ( parents.count() > 0 )
		{
			position = parents.first()->positionMe( coords );
			initComplete = true;
		}
	}

	//	Move this point to correct position
	if ( parents.count() > 0 )
	{
		parents.first()->moveMe( coords, position );
  }

	//	Calculate new rectangle around point.
	if ( ( size % 2 ) == 0 )
		size += 1;

	int x = coords.getI_X() - ( ( size - 1 ) / 2 );
	int y = coords.getI_Y() - ( ( size - 1 ) / 2 );

	//  Set rectangle.
	surroundingRect = QRect ( x, y, size, size );
}



