/***************************************************************************
                          rotation.cpp  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rotation.h"

Rotation::Rotation(): GeoPoint()
{
	identificator = "Rotation";
	ID = ID_rotation;

	int temp[] = { ID_geoPoint, 2, ID_arc, 1, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

Rotation::~Rotation()
{
}

void Rotation::move()
{
	if ( isTrace )
	{
		trace.append( new QRect( surroundingRect ) );
	}

	int indexPoint = 0;
	int indexCenter = 1;
	int indexArc = 2;

	if ( parents.at( 0 )->identify() == "Arc" )
	{
  	indexPoint = 1;
  	indexCenter = 2;
  	indexArc = 0;
	}
	else if ( parents.at( 1 )->identify() == "Arc" )
	{
  	indexPoint = 0;
  	indexCenter = 2;
  	indexArc = 1;
	}

	Coordinates coord1;
	coords = parents.at( indexPoint )->getCoordinates();	
	coord1 = parents.at( indexCenter )->getCoordinates();	

	double myAngle = parents.at( indexArc )->getAngle();

	coords.rotate( coord1, myAngle );

	//	Calculate new rectangle around point.
	if ( ( size % 2 ) == 0 )
		size += 1;

	int x = coords.getI_X() - ( ( size - 1 ) / 2 );
	int y = coords.getI_Y() - ( ( size - 1 ) / 2 );

	//  Set rectangle.
	surroundingRect = QRect ( x ,y ,size ,size );
}

