#ifndef COMMON_BOARD_H
#define COMMON_BOARD_H

#include "base/board.h"


class GiftPool;
class AI;

class Board : public BaseBoard
{
 Q_OBJECT
 public:
    Board(bool graphic, GiftPool *, QWidget *parent);
	virtual ~Board();

	void setType(bool computer);
	virtual void init(const GTInitData &);
	void unpause();
	void stop();

	virtual uint gift() = 0;
	virtual bool needRemoving() = 0;

	GiftPool *giftPool() const { return _giftPool; }

 public slots:
    void pMoveLeft();
    void pMoveRight();
    void pDropDown();
    void pOneLineDown();
    void pRotateLeft();
    void pRotateRight();

 private slots:
    bool timeout();

 signals:
    void updateLevelSignal(int level);

 protected:
    KRandomSequence randomGarbage;

	virtual bool beforeGlue(bool bump, bool first);
	virtual void gluePiece();
	virtual bool afterGlue(bool /*doAll*/, bool /*first*/) { return false; }
	virtual bool afterGift(bool /*first*/) { return false; }
	virtual bool putGift(uint) = 0;

    void updateLevel(uint newLevel);

 private:
    uint      _dropHeight;
	GiftPool *_giftPool;
	AI       *aiEngine;

    void newPiece();
	void pieceDropped(uint dropHeight);
    void checkGift();
	void _afterGift(bool first);
	void _beforeGlue(bool first);
	void _afterGlue(bool first);
    void afterAfterRemove() { checkGift(); }
	bool startTimer();
	void showBoard(bool show);
};

#endif
