#include "main.h"
#include "main.moc"

#include <klocale.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include "common/highscores.h"
#include "board.h"
#include "piece.h"
#include "ai.h"
#include "field.h"


const MPGameInfo MP_GAME_INFO = {
        "005", // multiplayer id (increase when incompatible changes are made
        4,     // max nb local games
        500,   // interval
        TRUE,  // IA allowed
        0, 0   // no setting slots
};

const MainData MAIN_DATA = {
    "ksirtet",
    I18N_NOOP("KSirtet"),
    I18N_NOOP("KSirtet is an adaptation of the well-known Tetris game."),
    "http://ksirtet.sourceforge.net/",
    I18N_NOOP("Removed lines")
};

const BoardInfo BOARD_INFO = {
    10, 22, // width - height
    true,

    15, 100, false, // block size (min, max, must be odd)

    1000, // base time
    10,   // drop down time
    10,   // before glue time
    10,   // after glue time
    150,  // before remove time
    10,   // after removed time
    10,   // after gift time
    3,    // nb bump stages
    3,    // nb toggles
    5,    // nb partial fall stages

    3, 3, 800, 2000  // nb leds, nb max to send, shower timeout, pool timeout
};

KSMainWindow::KSMainWindow()
{
    init(MP_GAME_INFO);
}

const MainData &KSMainWindow::mainData() const
{
    return MAIN_DATA;
}

const BoardInfo &KSMainWindow::boardInfo() const
{
    return BOARD_INFO;
}

BaseField *KSMainWindow::createField(QWidget *parent)
{
    Field *field = new KSField(parent);
    field->settingsChanged();
    QObject::connect(parent->parent(), SIGNAL(settingsChanged()),
                     field, SLOT(settingsChanged()));
    return field;
}

BaseBoard *KSMainWindow::createBoard(bool graphic, QWidget *parent)
{
	return new KSBoard(graphic, parent);
}

AI *KSMainWindow::createAI()
{
	return new KSAI(0, 200); // times need tuning ?
}

//-----------------------------------------------------------------------------
int main(int argc, char **argv)
{
    KLocale::setMainCatalogue("ksirtet");
	KAboutData aboutData(MAIN_DATA.name, MAIN_DATA.trName, LONG_VERSION,
                         MAIN_DATA.description, KAboutData::License_GPL,
                         COPYLEFT, 0, MAIN_DATA.homepage);
    aboutData.addAuthor("Nicolas Hadacek", 0, "hadacek@kde.org");
	aboutData.addAuthor("Eirik Eng", I18N_NOOP("Core engine"));
	KCmdLineArgs::init(argc, argv, &aboutData);

	KApplication a;
    KGlobal::locale()->insertCatalogue("libkdegames");
    KGlobal::locale()->insertCatalogue("libkdehighscores");

    KSPieceInfo pieceInfo;
    KExtHighscores::ExtHighscores highscores(MAIN_DATA);

    if ( kapp->isRestored() ) RESTORE(KSMainWindow)
    else {
        KSMainWindow *mw = new KSMainWindow;
        kapp->setMainWidget(mw);
        mw->show();
    }
	return kapp->exec();
}
