#ifndef __KGVSHELL_H__
#define __KGVSHELL_H__

#include <qstring.h>

#include <kparts/mainwindow.h>

class QTimer;

class KRecentFilesAction;
class ScrollBox;
class KGVPart;
class KToggleAction;
class KAction;
class KActionCollection;

class KGVShell : public KParts::MainWindow
{
  Q_OBJECT
public:
  KGVShell();
  virtual ~KGVShell();

public slots:
  void openURL( const KURL & url );
  void openStdin (  );
 
protected slots:

  void slotFileOpen();
  void slotFitToPage();
  void slotResize();
  void slotShowToolBar();
  void slotShowStatusBar();
  void slotQuit();

 protected:
  void readSettings();
  void writeSettings();
  void keyPressEvent (QKeyEvent *);
  void enableStateDepActions( bool enable );

private:
  KGVPart *m_gvpart;
  KRecentFilesAction *recent;
  KAction *openact;
  QString cwd;
  KToggleAction *showtoolbar, *showstatusbar;
  KActionCollection *statedep;
  unsigned int width0, height0;
};

#endif
