/*
* khelpidx.h -- Declaration of class KHelpIndex.
* Generated by newclass on Thu Sep  3 13:16:48 EST 1998.
*/
#ifndef SSK_KHELPIDX_H
#define SSK_KHELPIDX_H

#include<qdict.h>
#include<qstring.h>

/**
* Context index for an application's help pages.
*
*	Sample usage:
* <pre>
*	KHelpIndex index( "korn/korn.idx" );	
*
*	index.invoke( tag );
*
* </pre>
*
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: khelpidx.h,v 1.3 2000/08/06 10:25:11 bieker Exp $
*/
class KHelpIndex
{

private:
	bool _valid;

	QDict<QString> *_index;
	QString *_path;
	QString *_basename;

public:
	/**
	* KHelpIndex Constructor
	*/
	KHelpIndex( const QString & path ) ;

	/**
	* KHelpIndex Destructor
	*/
	virtual ~KHelpIndex();
	
	/**
	* Returns true if this object is valid, ie
	* given a path that exists and is readable.
	*/
	bool valid() const { return _valid; }

	/**
	* Invoke help for the given tag.
	* @return true if the tag was found, false otherwise.
	*/
	virtual bool invoke( const QString & tag );

protected:
	QDict<QString> *index() { return _index; }

	virtual bool readIndex( const QString & path );

private:

	KHelpIndex& operator=( KHelpIndex& );
	KHelpIndex( const KHelpIndex& );
};

#endif // SSK_KHELPIDX_H
