/*
* kview.cpp -- Implementation of class KView.
* Author:	Sirtaj Singh Kang
* Version:	$Id: kview.cpp,v 1.15 2000/09/03 01:34:56 waba Exp $
* Generated:	Wed Oct 15 01:26:27 EST 1997
*/

#include <assert.h>

#include <qimage.h>
#include <qfile.h>

#include <kapp.h>
#include <kcmdlineargs.h>
#include <kimageio.h>

#include "kview.h"
#include "viewer.h"
#include "filter.h"
#include "filtlist.h"
#include "filtmenu.h"
#include "colour.h"
#include "khelpidx.h"

KView::KView()
	: QObject( 0 ),
	_app(),
	_filters( new KFilterList ),
	_helper( new KHelpIndex( "kview/kview.index" ) ),
	_viewers( new QList<KImageViewer> ),
	_filtMenus( new QPtrDict<KFiltMenuFactory> ),
	_cutBuffer( 0 )
{
	assert( _filters );

	_viewers->setAutoDelete( true );
	_filtMenus->setAutoDelete( true );

	KImageIO::registerFormats();

	registerBuiltinFilters();
}

KView::~KView()
{
   delete _viewers; _viewers = 0;
   delete _helper; _helper = 0;
   delete _filters; _filters = 0;
   delete _filtMenus; _filtMenus = 0;
}

int KView::exec()
{
   if( _app.isRestored() ) 
   {
      // restore saved viewers
      for ( int i = 1; KImageViewer::canBeRestored( i ); i++ ) 
      {
         makeViewer()->restore( i );
      }
   }
   else 
   {
      KImageViewer *viewer = makeViewer();
      viewer->show();

      // process arguments only if not restored
      KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
      for( int i = 0; i < args->count(); i++ ) 
      {
         viewer->appendURL( args->url(i), (i == 0)  );
      }
   }

   return _app.exec();
}

void KView::registerBuiltinFilters()
{
	_filters->registerFilter( new BriteFilter, 
		KFilterList::AutoDelete );
	_filters->registerFilter( new GreyFilter, 
		KFilterList::AutoDelete );
	_filters->registerFilter( new SmoothFilter, 
		KFilterList::AutoDelete );
	_filters->registerFilter( new GammaFilter, 
		KFilterList::AutoDelete );
}


void KView::help( const QString & tag )
{
	assert( _helper );
	_helper->invoke( tag );
}

void KView::newViewer()
{
	KImageViewer *viewer = makeViewer();
	
	viewer->show();
}

KImageViewer *KView::makeViewer()
{
	KImageViewer *viewer = new KImageViewer;

	if( viewer == 0 )
		return 0;

	KFiltMenuFactory *menu = new KFiltMenuFactory( _filters );
	viewer->setFilterMenu( menu );

	_viewers->append( viewer );
	_filtMenus->insert( viewer, menu );

	connect( viewer, SIGNAL(wantHelp( const QString &)),
		this, SLOT(help(const QString &)) );
	connect( viewer, SIGNAL(wantNewViewer()),
		this, SLOT(newViewer()) );
	connect( viewer, SIGNAL(wantToDie(KImageViewer *)),
		this, SLOT(closeViewer(KImageViewer *)) );
	connect( viewer, SIGNAL(accelChanged()),
		this, SLOT( updateAllAccels()) );

	return viewer;
}

void KView::closeViewer( KImageViewer *viewer )
{
	assert( viewer != 0 );

	_filtMenus->remove( viewer );
	_viewers->remove( viewer );

	if( _viewers->count() == 0 ) {
		kapp->quit();
	}
}

void KView::setCutBuffer( QPixmap * )
{
	if( _cutBuffer ) {
		delete _cutBuffer; _cutBuffer = 0;
	}
	
}

void KView::updateAllAccels()
{
	QListIterator<KImageViewer> iter( *_viewers );

	for( ; iter.current(); ++iter ) {
		iter.current()->updateAccel();
	}
}

#include "kview.moc"

