/*
* typolayout.h -- Declaration of class KTypoLayout.
* Generated by newclass on Tue May  5 01:12:37 EST 1998.
*/
#ifndef SSK_TYPOLAYOUT_H
#define SSK_TYPOLAYOUT_H

class QButtonGroup;
class QPushButton;
class QCheckBox;
class QGridLayout;
class QLabel;
class QLineEdit;
class QMultiLineEdit;
class KListBox;
class QRadioButton;
class QWidget;

#include"baglayout.h"

/**
* Provides a @ref KBagLayout with widget generation.
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: typolayout.h,v 1.5 2000/08/06 10:25:11 bieker Exp $
*/
class KTypoLayout : public KBagLayout
{
	Q_OBJECT
private:
	KBagLayout *_layout;

public:
	/**
	* KTypoLayout Constructor
	*/
	KTypoLayout( QWidget *parent );

	QLabel *newLabel( const QString & text, int x, int y, 
			int xspan=1, int yspan=1 );
	QPushButton *newButton( const QString & text, int x, int y, 
			int xspan=1, int yspan=1 );
	QRadioButton *newRadioButton( const QString & text, int x, int y, 
			int xspan=1, int yspan=1 );
	QLineEdit *newLineEdit( const QString & text, int x, int y, 
			int xspan=1, int yspan=1 );
	QMultiLineEdit *newMultiLineEdit( const QString & text, 
			int x, int y,
			int xspan=1, int yspan=1 );
	QCheckBox *newCheckBox( const QString & text, int x, int y, 
			int xspan=1, int yspan=1 );
	KListBox *newListBox( int x, int y, 
			int xspan=1, int yspan=1 );

	KTypoLayout *newSubLayout( int x, int y, int xspan=1, int yspan=1 );
	KTypoLayout *newSubGroup( const QString & title, 
		int x, int y, int xspan=1, int yspan=1 );

	QButtonGroup *startGroup();
	void endGroup();

private:
	KTypoLayout& operator=( KTypoLayout& );
	KTypoLayout( const KTypoLayout& );

	QWidget *_parent;
	QButtonGroup *_group;

	void layoutWidget( QWidget *w, int x, int y, int xspan, int yspan );
};

#endif // SSK_TYPOLAYOUT_H
