/***************************************************************************
                          filter_pab.cxx  -  description
                             -------------------
    begin                : Fri Jun 30 2000
    copyright            : (C) 2000 by Hans Dijkema
    email                : kmailcvt@hum.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filter_pab.hxx"
#include "pablib.hxx"

#include <kfiledialog.h>

filter_pab::filter_pab() : filter(i18n("Import MS Exchange Personal Address Book (.PAB)"),"Hans Dijkema")
{}

filter_pab::~filter_pab()
{}

void filter_pab::import(filterInfo *info)
{
QString _file;
char     file[1024];
char     dir[1024];
QWidget *parent=info->parent();
   sprintf(dir,getenv("HOME"));

   _file=KFileDialog::getOpenFileName(dir,"*.pab *.PAB *.Pab",parent);
   if (_file.length()==0) {
     info->alert(name(),i18n("No Addressbook choosen"));
     return;
   }
   strcpy(file,_file.latin1());

   {pab PAB(file,this,info);
    QString from=i18n("Source: "),to=i18n("Destination: ");
      from+="\t";
      from+=file;
      to+="\t";
      to+=i18n("the K Addressbook");
      info->from(from);
      info->to(to);
      info->current(i18n("Currently converting .PAB addresses to Kab"));
      PAB.convert();
      info->current(i18n("Done converting .PAB addresses to Kab"));
   }
}
