/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qspinbox.h>

#include <kstandarddirs.h>
#include <klocale.h>
#include <kurlrequester.h>
#include <kfiledialog.h>

#include "page_general.h"

PageGeneral::PageGeneral( QWidget *parent, const char *name ) : PageGeneralBase( parent, name)
{
    modePreview->setPixmap(QPixmap(locate("data","ksirc/pics/sdi.png")));
    wallpaperPathLE->fileDialog()->setFilter( I18N_NOOP( "*.jpg *.png *.gif" ) );
}

PageGeneral::~PageGeneral()
{
}

void PageGeneral::saveConfig()
{
    if ( mdiCB->isChecked() ) ksopts->displayMode = KSOptions::MDI;
    if ( sdiCB->isChecked() ) ksopts->displayMode = KSOptions::SDI;
    
    ksopts->autoCreateWin = autoCreateWindowCB->isChecked();
    ksopts->nickCompletion = nickCompletionCB->isChecked();
    ksopts->displayTopic = displayTopicCB->isChecked();
    ksopts->timeStamp = timeStampCB->isChecked();
    ksopts->beepNotify = beepCB->isChecked();
    ksopts->colorPicker = colorPickerPopupCB->isChecked();
    ksopts->autoRejoin = autoRejoinCB->isChecked();

    ksopts->windowLength = historySB->value();

    ksopts->backgroundFile = wallpaperPathLE->url();
}

void PageGeneral::readConfig( const KSOGeneral *opts )
{
    if ( opts->displayMode == KSOptions::MDI )
        mdiCB->setChecked( true );
    else
        sdiCB->setChecked( true );
        
    autoCreateWindowCB->setChecked( opts->autoCreateWin );
    nickCompletionCB->setChecked( opts->nickCompletion );
    displayTopicCB->setChecked( opts->displayTopic );
    timeStampCB->setChecked( opts->timeStamp );
    beepCB->setChecked( opts->beepNotify );
    colorPickerPopupCB->setChecked( opts->colorPicker );
    autoRejoinCB->setChecked( opts->autoRejoin );

    historySB->setValue( opts->windowLength );

    wallpaperPathLE->setURL( opts->backgroundFile );
}

void PageGeneral::defaultConfig()
{
    KSOGeneral opts;
    readConfig( &opts );
}

void PageGeneral::setPreviewPixmap( bool isSDI )
{
    if (isSDI == true)
        modePreview->setPixmap( QPixmap( locate("data", "ksirc/pics/sdi.png" ) ) );
    else
        modePreview->setPixmap( QPixmap( locate("data", "ksirc/pics/mdi.png" ) ) );
}

void PageGeneral::showWallpaperPixmap( const QString &url )
{
    wallpaperPreview->setPixmap( QPixmap( url ) );
}

void PageGeneral::changed()
{
    emit modified();
}

#include "page_general.moc"
