/*
    kpgpui.h

    Copyright (C) 2001,2002 the KPGP authors
    See file AUTHORS.kpgp for details

    This file is part of KPGP, the KDE PGP/GnuPG support library.

    KPGP is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 */

#ifndef KPGPUI_H
#define KPGPUI_H

#include <kdialogbase.h> // base class of all dialogs here
#include <qwidget.h>     // base class of Config
#include <qcheckbox.h>   // used in inlined methods
#include <kdebug.h>      // dto.
#include <qcstring.h>    // used in return-by-value


//#include "kpgp.h"

class QString;
class QCString;
class QCheckBox;            // needed by Config, KeySelectionDialog
class QListView;            // needed by KeySelectionDialog
class QMultiLineEdit;       // needed by CipherTextDialog
class QComboBox;            // needed by Config
class QPixmap;              // needed by KeySelectionDialog

class KPasswordEdit;        // needed by PassphraseDialog

namespace Kpgp {

class Module;
class KeyList;              // needed by KeySelectionDialog
class Key;                  // needed by KeySelectionDialog

/** the passphrase dialog */
class PassphraseDialog : public KDialogBase
{
  Q_OBJECT

  public:
    PassphraseDialog( QWidget *parent=0, const QString &caption=QString::null,
                      bool modal=true, const QString &keyID=QString::null);
    virtual ~PassphraseDialog();

    const char * passphrase();

  private:
    KPasswordEdit *lineedit;
};


// -------------------------------------------------------------------------
/** a widget for configuring the pgp interface. Can be included into
    a tabdialog. This widget by itself does not provide an apply/cancel
    button mechanism. */
class Config : public QWidget
{
  Q_OBJECT

  public:
    Config(QWidget *parent = 0, const char *name = 0, bool encrypt =true);
    virtual ~Config();

    virtual void setValues();
    virtual void applySettings();

  protected:
    Module *pgp;
    QCheckBox *storePass;
    QCheckBox *encToSelf;
    QCheckBox *showCipherText;
    QCheckBox *showKeyApprovalDlg;
    QComboBox *toolCombo;
};


// -------------------------------------------------------------------------
class KeySelectionDialog: public KDialogBase
{
  Q_OBJECT

  public:
    /** acceptedKeys: 0 = all keys are accepted
                      1 = only valid encryption keys are accepted
                      2 = only valid signing keys are accepted
     */
    KeySelectionDialog( const KeyList& keyList, const QString& title,
                        const QString& text = QString::null,
                        const QCString& keyId = QCString(),
                        const bool rememberChoice = false,
                        const int acceptedKeys = 0,
                        QWidget *parent=0, const char *name=0,
                        bool modal=true );
    virtual ~KeySelectionDialog() {};

    virtual QCString key(void) const {return mKeyID;};
    virtual bool rememberSelection() const { if (mRememberCB)
                                               return mRememberCB->isChecked();
                                             else
                                               return false; };

  protected slots:
    virtual void slotSelectionChanged( QListViewItem * );
    virtual void slotOk();
    virtual void slotCancel();

  private:
    void initKeylist( const KeyList& keyList, const QCString& keyId );

    QString keyInfo( const Kpgp::Key * ) const;

    // Returns: -1 = bad, 0 = unknown, 1 = good
    int keyValidity( const Kpgp::Key * ) const;

    // Updates the selected key with the data of the given key
    void updateSelectedKey( const Kpgp::Key * ) const;

    // Should return true if it's ok to choose this key
    bool acceptKey( const QCString& ) const;

    QListView *mListView;
    QCheckBox *mRememberCB;
    QCString mKeyID;
    QPixmap *keyGood, *keyBad, *keyUnknown;
    int mAcceptedKeys;
};


// -------------------------------------------------------------------------
class KeyApprovalDialog: public KDialogBase
{
  Q_OBJECT

  public:
    KeyApprovalDialog( const QStringList&, const QStrList&,
                       QWidget *parent = 0, const char *name = 0,
                       bool modal = true );
    virtual ~KeyApprovalDialog() {};

    QStrList keys() const { return mKeys; };

    bool preferencesChanged() const { return mPrefsChanged; }

  protected slots:
    void slotPrefsChanged( int ) { mPrefsChanged = true; };
    void slotChangeEncryptionKey( int );
    virtual void slotOk();
    virtual void slotCancel();
    virtual void show();

  private:
    QStrList mKeys;
    bool mPrefsChanged;
    QPtrList<QLabel> mAddressLabels;
    QPtrList<QLabel> mKeyIdLabels;
    //QButtonGroup *mChangeButtonGroup;
    //QPtrList<QPushButton> mChangeButtons;
    QPtrList<QComboBox> mEncrPrefCombos;
};


// -------------------------------------------------------------------------
class CipherTextDialog: public KDialogBase
{
  Q_OBJECT

  public:
    CipherTextDialog( const QCString & text, const QCString & charset=0,
                      QWidget *parent=0, const char *name=0, bool modal=true );
    virtual ~CipherTextDialog() {};

  private:
    QMultiLineEdit *mEditBox;
};

}; // namespace Kpgp

#endif
