/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "kbabelsplash.h"

#include <kstandarddirs.h>
#include <kwin.h>

#include <qapplication.h>
#include <qlabel.h>
#include <qpixmap.h>


QWidget *KBabelSplash::_splashWidget = 0;

QWidget *KBabelSplash::splash()
{
    QPixmap pixmap(locate("data","kbabel/pics/splash.png"));
    
    QLabel *splash = new QLabel(0,"splash", Qt::WStyle_Customize 
            | Qt::WStyle_NoBorder);
    KWin::setState(splash->winId() , NET::SkipTaskbar);

    splash->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
    splash->setPixmap(pixmap);
    splash->adjustSize();
    QSize sh = splash->sizeHint();
    
    splash->move((QApplication::desktop()->width()-sh.width())/2,
            (QApplication::desktop()->height()-sh.height())/2);
    splash->show();
    splash->repaint(false);
    
    _splashWidget = splash;

    return splash;
}
