
#include "bug.h"

#include "bugimpl.h"

#include <assert.h>
#include <kdebug.h>

Bug::Bug()
{
}

Bug::Bug( BugImpl *impl ) :
    m_impl( impl )
{
}

Bug::Bug( const Bug &other )
{
    (*this) = other;
}

Bug Bug::fromNumber( const QString &bugNumber )
{
    return new BugImpl( QString::null, Person(), bugNumber, 0, Normal, Open );
}

Bug &Bug::operator=( const Bug &rhs )
{
    m_impl = rhs.m_impl;
    return *this;
}

Bug::~Bug()
{
}

QString Bug::severityToString( Bug::Severity s )
{
    switch ( s )
    {
        case Critical: return QString::fromLatin1( "Critical" );
        case Grave: return QString::fromLatin1( "Grave" );
        case Crash: return QString::fromLatin1( "Crash" );
        case Normal: return QString::fromLatin1( "Normal" );
        case WishList: return QString::fromLatin1( "WishList" );
        default: kdWarning() << "Bug::severityToString invalid severity " << s << endl;
                 return QString::fromLatin1( "<invalid>" );
    }
    assert( false );
    return QString::null;
}

Bug::Severity Bug::stringToSeverity( const QString &_s, bool *ok )
{
   QString s = _s.lower();
   if ( ok )
      *ok = true;

   if ( s == "critical" ) 
       return Critical; 
   else if ( s == "grave" ) 
       return Grave; 
   else if ( s == "crash" || s == "drkonqi" ) 
       return Crash; 
   else if ( s == "normal" ) 
       return Normal; 
   else if ( s == "wishlist" ) 
       return WishList; 

   kdWarning() << "Bug::stringToSeverity: invalid severity: " << s << endl;
   if ( ok )
       *ok = false;
   return Normal;
}

QValueList<Bug::Severity> Bug::severities()
{
    QValueList<Severity> s;
    s << Critical << Grave << Crash << Normal << WishList;
    return s;
}

QString Bug::statusToString( Bug::Status s )
{
    switch ( s )
    {
        case Closed: return QString::fromLatin1( "Closed" );
        case Open:   return QString::fromLatin1( "Open" );
    }
    assert( false );
    return QString::null;
}

Bug::Status Bug::stringToStatus( const QString &_s, bool *ok )
{
   QString s = _s.lower();
   if ( ok )
      *ok = true;

   if ( s == "closed" ) 
       return Closed; 
   else if ( s == "open" ) 
       return Open; 

  kdDebug() << "Bug::stringToStatus: Unknown status '" << _s
            << "': Returned 'Open' status." << endl;
            
   if ( ok )
       *ok = false;
   return Open;
}

QString Bug::title() const
{
    if ( !m_impl )
        return QString::null;
    
    return m_impl->title;
}

struct Person Bug::submitter() const
{
    if ( !m_impl )
        return Person( QString::null, QString::null );

    return m_impl->submitter;
}

QString Bug::number() const
{
    if ( !m_impl )
        return QString::null;
    
    return m_impl->number;
}

uint Bug::age() const
{
   if ( !m_impl )
       return 0;

   return m_impl->age;
}

Bug::Severity Bug::severity() const
{
    if ( !m_impl )
        return Normal;

    return m_impl->severity;
}

Bug::Status Bug::status() const
{
    if ( !m_impl )
        return Open;

    return m_impl->status;
}

QString Bug::severityAsString() const
{
    return severityToString( severity() );
}

bool Bug::operator==( const Bug &rhs )
{
    return m_impl == rhs.m_impl;
}

bool Bug::operator<( const Bug &rhs ) const
{
    return m_impl < rhs.m_impl;
}

/* vim: set ts=4 sw=4 et softtabstop=4: */

