/* 
 * APPLICATION PRINT SERVICES LIBRARY
 * (C) Copyright 2000 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: CupsTransport.h
 *
 * Description: Definitions specifically to the CUPS transport
 *              abstraction layer.
 *
 */

#ifndef CUPSTRANSPORT_H
#define CUPSTRANSPORT_H

#include "transport.h"
#include <cups/cups.h>

Transport *CupsCreateTransport();

typedef struct _CupsFunctionPointers
{
    void *pSharedObject;
    int (*cupsCancelJob) (const char *name, int job);

     ipp_t(*cupsDoRequest) (http_t http, ipp_t request, const char *resource);
     ipp_t(*cupsDoFileRequest) (http_t * http, ipp_t * request,
                                const char *resource, const char *filename);
    int (*cupsGetClasses) (char ***classes);
    const char *(*cupsGetDefault) (void);
    const char *(*cupsGetPPD) (const char *printer);
    int (*cupsGetPrinters) (char ***printers);
     ipp_status_t(*cupsLastError) (void);
    int (*cupsPrintFile) (const char *printer, const char *filename,
                          const char *title, int num_options,
                          cups_option_t * options);
    char (*cupsTempFile) (char *filename, int len);
    int (*cupsAddOption) (const char *name, const char *value,
                          int num_options, cups_option_t ** options);
    void (*cupsFreeOptions) (int num_options, cups_option_t * options);
    const char (*cupsGetOption) (const char *name, int num_options,
                                 cups_option_t * options);
    int (*cupsParseOptions) (const char *arg, int num_options,
                             cups_option_t ** options);
    int (*cupsMarkOptions) (ppd_file_t * ppd, int num_options,
                            cups_option_t * options);

    const char (*cupsGetPassword) (const char *prompt);
    const char (*cupsServer) (void);
    const char (*cupsUser) (void);
}
CupsFunctionPointers;

typedef struct CupsTransport_
{
    Transport baseClass;
    CupsFunctionPointers CupsInterface;
    /* CupsTransport specific data
     */
}
CupsTransport;

#endif /* !CUPSTRANSPORT_H */
