/* 
 * APS Application Print Services library
 * (C) Copyright 1999 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: queue.h
 *
 * Description: Definition of the queue structure. There is one instance
 *              of this structure for each queue opener (multiple
 *              copies may be present at the same time).
 *
 */

#ifndef QUEUE_H
#define QUEUE_H

typedef struct Queue_ Queue;

#include "aps.h"
#include "apsinternal.h"
#include "printer.h"
#include "job.h"
#include "object.h"

/* Queue control structure */
struct Queue_ {
    ApsObject baseClass;             /* baseclass */
    Aps_PrinterHandle printerHandle; /* printer, NULL = GLOBAL */
};

/* Internal protos */
Queue *QueueGetPtrFromHandle(Aps_QueueHandle handle);
Aps_QueueHandle QueueGetHandleFromPtr(Queue * queue);
Aps_Result QueueCreate(Aps_PrinterHandle printerHandle,
    Aps_QueueHandle *queueHandle);
void QueueDelete(Queue *queue);
Aps_Result QueueIterateAllJobs(Aps_QueueHandle queueHandle,
    Aps_JobHandle *jobHandle);
Aps_Result QueueCheckFilter(Queue *queue, Aps_JobHandle job, int *match);

/* IsOperationAvailable support */
Aps_Result QueueIsOperationAvailable(Queue *queue,
    Aps_OperationID operation, Aps_Result *anticipatedResult);

#endif /* !QUEUE_H */
