/* 
 * APS Application Print Services library
 * (C) Copyright 1999 Corel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *
 *
 *        File: testaps.C
 *
 * Description: defines the member method of class TestAps
 */



#include "testaps.h"
#include "apsdefs.h"

#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#if (QT_VERSION < 200)
#include <qmultilinedit.h>
#else
#include <qmultilineedit.h>
#endif
#include <qlabel.h>
#include <qmessagebox.h>
#include <aps.h>

/* ---------------------------------------------------------------------------
 * Constructor 
 *
 * Creates all the widget required in APS test program.
 *
 * Parameters: Nil.
 *
 *     Return: Nil.
 *            
 */
TestAps::TestAps()
	: QWidget(0, 0, 0)
{
    // Initialize all handles to NULL
    lastPrinterHandle = NULL;
    lastJobHandle = NULL;
    lastJobAttrHandle = NULL;
    //Create a list box
    listLibNames =  new QListBox(this); // Check for the syntex
    listLibNames->setMultiSelection(false); 
    listLibNames->setGeometry(20, 20, 150, 200);
    // Set the number of items visible
    //listLibNames->set
    // Insert the name of the Aps APIs in the list here
    QString str;
    numCalls = (sizeof(callInfo)/sizeof(ApsCallInfo));
    for(int tmp = 0; tmp <  numCalls ; tmp++){
       str.sprintf("%s", callInfo[tmp].callName);
       listLibNames->insertItem(str, tmp);
    }
    connect(listLibNames, SIGNAL(highlighted(int)), this, SLOT(SlotHighlightedItem(int)));
    
    //Create a label to show the heading for the Input parameters
    QLabel  *inputParam = new QLabel("Input Parameters", this);
    inputParam->setGeometry(175, 10, 100, 30);
	
    // Create the Execute Push button
    pbExecute = new QPushButton("Execute", this);
    pbExecute->setGeometry(100, 310, 100, 30);
    pbExecute->setEnabled(FALSE);
    connect (pbExecute, SIGNAL(clicked()), this, SLOT(Execute()));
    // Write the code to connect clicked() signal to the appropriate SLOT
    pbExit = new QPushButton("Exit", this);
    pbExit->setGeometry(300, 310, 100, 30);
    // connect clicked() signal to Quit SLOT
    connect (pbExit, SIGNAL(clicked()), this, SLOT(Quit()));

    // Create label for Input parameter1 heading    
    labelInput1 = new QLabel("", this); 
    labelInput1->setGeometry(200, 40, 150, 20); 
    // First Input parameter
    editInput1 = new QLineEdit(this, "test1");
    editInput1->setGeometry(200, 60, 100, 25); 

    // Create label for Input parameter2 heading    
    labelInput2 = new QLabel("", this); 
    labelInput2->setGeometry(310, 40, 100, 20); 
    // Second Input parameter
    editInput2 = new QLineEdit(this, "test1");
    editInput2->setGeometry(310, 60, 100, 25); 

    // Create label for Input parameter3 heading    
    labelInput3 = new QLabel("", this); 
    labelInput3->setGeometry(200, 90, 100, 20); 
    // Third Input parameter
    editInput3 = new QLineEdit(this, "test1");
    editInput3->setGeometry(200, 110, 100, 25); 

    // Create label for Input parameter4 heading    
    labelInput4 = new QLabel("", this); 
    labelInput4->setGeometry(310, 90, 100, 20); 
    // Fourth Input parameter
    editInput4 = new QLineEdit(this, "test1");
    editInput4->setGeometry(310, 110, 100, 25); 

    // Create label for Input parameter5 heading    
    labelInput5 = new QLabel("", this); 
    labelInput5->setGeometry(420, 40, 120, 20); 
    // Fifth Input parameter
    editInput5 = new QMultiLineEdit(this, "test1");
    editInput5->setGeometry(420, 60, 170, 110); 
    editInput5->setEnabled(FALSE); 

    //Create a label to show the heading for the Output parameters
    QLabel  *outputParam = new QLabel("Output Parameters", this);
    outputParam->setGeometry(175, 150, 120, 30);

    // Create label for Output parameter1 heading    
    labelOutput1 = new QLabel("", this); 
    labelOutput1->setGeometry(200, 175, 200, 20); 
    // First Output parameter
    editOutput1 = new QLineEdit(this, "test1");
    editOutput1->setGeometry(200, 195, 250, 25); 

    // Create label for Output parameter2 heading    
    labelOutput2 = new QLabel("", this); 
    labelOutput2->setGeometry(460, 175, 100, 20); 
    // Second Output parameter
    editOutput2 = new QLineEdit(this, "test1");
    editOutput2->setGeometry(460, 195, 100, 25); 

    // Create label for Output parameter3 heading    
    labelOutput3 = new QLabel("", this); 
    labelOutput3->setGeometry(200, 225, 160, 20); 
    // Third Output parameter
    editOutput3 = new QLineEdit(this, "test1");
    editOutput3->setGeometry(200, 245, 160, 25); 

    // Result Editbox
    editResult = new QLineEdit(this);
    editResult->setGeometry(20, 250, 100, 25); 
    // Create label for Input parameter1 heading    
    labelResult = new QLabel("Result", this); 
    labelResult->setGeometry(20, 230, 170, 20); 
}

/* ---------------------------------------------------------------------------
 * Destructor 
 *
 * Deletes the instances of the widgets created in APS test program.
 *
 * Parameters: void
 *
 *     Return: void
 *            
 */
TestAps::~TestAps()
{
	delete listLibNames;
	delete pbExecute;
	delete pbExit;
	delete editInput1;
	delete labelInput1;
	delete editInput2;
	delete labelInput2;
	delete editInput3;
	delete labelInput3;
	delete editInput4;
	delete labelInput4;
	delete editInput5;
	delete labelInput5;
	delete labelOutput1;
	delete labelOutput2;
	delete labelOutput3;
	delete editResult;
	delete labelResult;
}

/* ---------------------------------------------------------------------------
 * SlotHighlightedItem() 
 *
 * This method is called when the item is selected from the list.
 *
 * Parameters: index - Position of the item in the list.
 *
 *     Return: void
 */            
void TestAps::SlotHighlightedItem(int index)
{
    selItemPos = index;
    // Set all the labels and edit boxes enabled first
    editInput1->setEnabled(TRUE);    
    editInput2->setEnabled(TRUE);    
    editInput3->setEnabled(TRUE);    
    editInput4->setEnabled(TRUE);    
    editInput5->setEnabled(TRUE);    
    labelInput1->setEnabled(TRUE);    
    labelInput2->setEnabled(TRUE);    
    labelInput3->setEnabled(TRUE);    
    labelInput4->setEnabled(TRUE);    
    labelInput5->setEnabled(TRUE);    
    editOutput1->setEnabled(TRUE);    
    editOutput2->setEnabled(TRUE);    
    editOutput3->setEnabled(TRUE);    
    labelOutput1->setEnabled(TRUE);    
    labelOutput2->setEnabled(TRUE);    
    labelOutput3->setEnabled(TRUE);    

    // Set the labels
    labelInput1->setText(callInfo[index].inputLabel1);    
    labelInput2->setText(callInfo[index].inputLabel2);    
    labelInput3->setText(callInfo[index].inputLabel3);    
    labelInput4->setText(callInfo[index].inputLabel4);    
    labelOutput1->setText(callInfo[index].outputLabel1);    
    labelOutput2->setText(callInfo[index].outputLabel2);    
    labelOutput3->setText(callInfo[index].outputLabel3);    
    // Clear the Edit text field
    editInput1->setText("");    
    editInput2->setText("");    
    editInput3->setText("");    
    editInput4->setText("");    
    editInput5->setText("");    
    editOutput1->setText("");    
    editOutput2->setText("");    
    editOutput3->setText("");    
    if (callInfo[index].isMultiLine)
        labelInput5->setText(callInfo[index].labelMultiLine);    
    else {
        labelInput5->setText("");    
        labelInput5->setEnabled(FALSE);    
        editInput5->setEnabled(FALSE);    
    }

    editResult->setText("");    
    // Set the sensitivity of the labels and edit text fields
    switch (callInfo[index].noInputParam) {
        case 0 :
            labelInput1->setEnabled(FALSE);
            editInput1->setEnabled(FALSE);
        case 1 :
            labelInput2->setEnabled(FALSE);
            editInput2->setEnabled(FALSE);
        case 2 :
            labelInput3->setEnabled(FALSE);
            editInput3->setEnabled(FALSE);
        case 3 :
            labelInput4->setEnabled(FALSE);
            editInput4->setEnabled(FALSE);
        case 4 :
            break;

    }
    switch (callInfo[index].noOutputParam) {
        case 0 :
            labelOutput1->setEnabled(FALSE);
            editOutput1->setEnabled(FALSE);
        case 1 :
            labelOutput2->setEnabled(FALSE);
            editOutput2->setEnabled(FALSE);
        case 2 :
            labelOutput3->setEnabled(FALSE);
            editOutput3->setEnabled(FALSE);
        case 3 :
            break;
    }
    pbExecute->setEnabled(TRUE);
    SetPrevHandles(index);
}

/* ---------------------------------------------------------------------------
 * quit() 
 *
 * This method is called when the Exit button selected from APS testprogram.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::Quit()
{
    exit(0);
}

/* ---------------------------------------------------------------------------
 * Execute() 
 *
 * This method is called when the Execute button selected from APS 
 * testprogram after selecting the item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::Execute()
{
    switch (selItemPos) {
        case 0 :
 	        RunDispatchJob();
	        break;
        case 1 :
                RunReleaseHandle();
	        break;
        case 2 :
                RunGetResultText();
	        break;
        case 3 :
                RunOpenDefaultPrinter();
	        break;
        case 4 :
                RunGetPrinters();
	        break;
        case 5 :
                RunOpenPrinter();
	        break;
        case 6 :
                RunGetDefaultJobSettings();
	        break;
        case 7 :
                RunSetDefaultJobSettings();
	        break;
        case 8 :
                RunGetProperty();
	        break;
        case 9 :
                RunSetProperty();
	        break;
        case 10 :
                RunStartJob();
	        break;
        case 11 :
                RunGetJobSettings();
	        break;
        case 12 :
                RunWrite();
	        break;
        case 13 :
                RunGetJobState();
	        break;
        case 14 :
                RunEndJob();
	        break;
        case 15 :
                RunCancelJob();
	        break;
        case 16 :
                RunGetPrinterName();
	        break;
        case 17 :
                RunGetPPDFilename();
	        break;
        case 18 :
                RunPrinterSetAsDefault();
	        break;
        case 19 :
                RunAddPrinter();
	        break;
        case 20 :
                RunPrinterRemove();
	        break;
        case 21 :
                RunPrinterIsDefault();
	        break;
        case 22 :
                RunPrinterRename();
	        break;
        case 23 :
                RunPrinterSetMaxJobSize();
	        break;
        case 24 :
                RunPrinterGetMaxJobSize();
	        break;
        case 25 :
                RunPrinterSetConfigFlags();
	        break;
        case 26 :
                RunPrinterGetConfigFlags();
	        break;
        case 27 :
                RunPrinterGetConnectInfo();
	        break;
        case 28 :
                RunPrinterSetConnectInfo();
	        break;
        default :
                RunBasicPrinting();
	        break;
    }
}

/* ---------------------------------------------------------------------------
 * RunDispatchJob() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_DispatchJob' item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunDispatchJob()
{
    Aps_Result  result;
    Aps_PrinterHandle printer = NULL;
    const char *filename;
    const char *format;
    Aps_JobAttrHandle attributes;
    Aps_JobHandle job = NULL;
    char  tmp[200];

    // Get the values of printer, filename, format, and 
    // settings from the edit boxes
    strcpy(tmp,  (const char *)editInput1->text());
    if ( strcmp(tmp, "")== 0)
        printer = NULL;
    else
        sscanf(tmp, "%p", &printer);
    filename = (const char *)editInput2->text();
    if (strcmp(filename, "")== 0)
    {
        MessageBox("Testing Aps_DispatchJob", "Filename not Specified");
        return;
    }
    format = (const char *)editInput3->text();
    if (strcmp(format, "")== 0)
       format = NULL;       
    
    //settings = (Aps_JobAttrHandle)editInput4->text();
    strcpy(tmp, editInput4->text());
    if ( strcmp(tmp, "")== 0)
        attributes = NULL;
    else
        sscanf(tmp, "%p", &attributes);

    result = Aps_DispatchJob(printer, (char *) filename, (char *) format, attributes, &job);
    SetResultEditBox(result);
    // Display the printer handle
    sprintf(tmp, "%p", job);
    editOutput1->setText(tmp);
}

/* ---------------------------------------------------------------------------
 * RunReleaseHandle() 
 filename*
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_ReleaseHandle' item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunReleaseHandle()
{
    Aps_Result  result;
    Aps_Handle  handle;
    char tmp[50];

    // Get the value of settings from the edit box 1 for the handle
    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_ReleaseHandle", "Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &handle);
    result =  Aps_ReleaseHandle(handle);
    if (result == APS_SUCCESS)
        lastPrinterHandle = NULL;
    SetResultEditBox(result);
}
/* ---------------------------------------------------------------------------
 * RunPrinterRemove() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_PrinterRemove' item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunPrinterRemove()
{
    Aps_Result  result;
    Aps_PrinterHandle  handle;
    char tmp[50];

    // Get the value of settings from the edit box 1 for the handle
    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_PrinterRemove", "Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &handle);
    result =  Aps_PrinterRemove(handle);
    SetResultEditBox(result);
    editInput1->setText("");
    lastPrinterHandle = NULL;
}
/* ---------------------------------------------------------------------------
 * RunPrinterRename() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_PrinterRename' item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunPrinterRename()
{
    Aps_Result  result;
    Aps_PrinterHandle  handle;
    char *newPrinterName;
    char *tmp;

    newPrinterName = (char *)malloc(512); 
    tmp  = (char *)malloc(50); 
    memset(newPrinterName, 0, 512);
    memset(tmp, 0, 50);
    // Get the value of settings from the edit box 1 for the handle
    strcpy(tmp, (const char *)editInput1->text());
    strcpy(newPrinterName, (const char *)editInput2->text());
    if (!strcmp(tmp, "")){
        MessageBox("Testing Aps_PrinterRename", "Handle not Specified");
        return;
    }
    if (!strcmp(newPrinterName, "")){
        MessageBox("Testing Aps_PrinterRename", "Printer name not Specified");
        return;
    }
    sscanf(tmp, "%p", &handle);
    result =  Aps_PrinterRename(handle, newPrinterName);
    SetResultEditBox(result);
}
/* ---------------------------------------------------------------------------
 * RunPrinterIsDefault() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_PrinterIsDefault' item from 
 * the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunPrinterIsDefault()
{
    Aps_Result  result;
    Aps_Handle  handle;
    char tmp[50];
    int isDefault;

    // Get the value of settings from the edit box 1 for the handle
    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_PrinterSetAsDefault", "Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &handle);
    result =  Aps_PrinterIsDefault(handle, &isDefault);
    if (isDefault == TRUE)
        editOutput1->setText("TRUE");
    else
        editOutput1->setText("FALSE");
    SetResultEditBox(result);
}

/* ---------------------------------------------------------------------------
 * RunPrinterSetAsDefault() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_PrinterSetAsDefault' item from 
 * the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunPrinterSetAsDefault()
{
    Aps_Result  result;
    Aps_Handle  handle;
    char tmp[50];

    // Get the value of settings from the edit box 1 for the handle
    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_PrinterSetAsDefault", "Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &handle);
    result =  Aps_PrinterSetAsDefault(handle);
    SetResultEditBox(result);
}
/* ---------------------------------------------------------------------------
 * RunPrinterGetConfigFlags() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_PrinterGetConfigFlags' item from 
 * the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunPrinterGetConfigFlags()
{
    Aps_Result  result;
    Aps_Handle  handle;
    char tmp[50];
    long int configFlags;

    // Get the value of settings from the edit box 1 for the handle
    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_PrinterGetConfigFlags", "Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &handle);
    result =  Aps_PrinterGetConfigFlags(handle, &configFlags);
    sprintf(tmp, "%ld", configFlags); 
    editOutput1->setText(tmp);
    SetResultEditBox(result);
}
/* ---------------------------------------------------------------------------
 * RunPrinterGetConnectInfo()
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_PrinterGetConnectInfo' item from 
 * the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunPrinterGetConnectInfo()
{
    Aps_Result  result;
    Aps_Handle  handle;
    int connectionType;
    char tmp1[1024], tmp2[50], *location;

    // Get the value of settings from the edit box 1 for the handle
    memset (tmp1, 0, 50);
    memset (tmp2, 0, 50);
    strcpy(tmp1, (const char *)editInput1->text());
    strcpy(tmp2, (const char *)editInput2->text());
    if (strcmp(tmp1, "") == 0){
        MessageBox("Testing Aps_PrinterGetConnectInfo", "Handle not Specified");
        return;
    }
    if (strcmp(tmp2, "") == 0){
        MessageBox("Testing Aps_PrinterGetConnectInfo", 
                              "Connection type not Specified");
        return;
    }
    sscanf(tmp1, "%p", &handle);
    sscanf(tmp2, "%d", &connectionType);
    result =  Aps_PrinterGetConnectInfo(handle, 
                      (Aps_ConnectionType * )&connectionType, &location);
    memset (tmp1, 0, 1024);
    if (location != NULL){
       sprintf(tmp1, "%s", location); 
       editOutput1->setText(tmp1);
    }
    SetResultEditBox(result);

}

/* ---------------------------------------------------------------------------
 * RunPrinterSetConnectInfo()
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_PrinterGetConnectInfo' item from 
 * the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunPrinterSetConnectInfo()
{
    Aps_Result  result;
    Aps_Handle  handle;
    int connectionType;
    char tmp1[50], tmp2[50], *tmp;

    // Get the value of settings from the edit box 1 for the handle
    tmp = (char *)malloc(1024);
    memset (tmp1, 0, 50);
    memset (tmp2, 0, 50);
    memset (tmp, 0, 1024);
    strcpy(tmp1, (const char *)editInput1->text());
    strcpy(tmp2, (const char *)editInput2->text());
    strcpy(tmp, (const char *)editInput3->text());
    if (strcmp(tmp1, "") == 0){
        MessageBox("Testing Aps_PrinterSetConnectInfo", "Handle not Specified");
        return;
    }
    if (strcmp(tmp2, "") == 0){
        MessageBox("Testing Aps_PrinterSetConnectInfo", 
                              "Connection type not Specified");
        return;
    }
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_PrinterSetConnectInfo", 
                              "location not Specified");
        return;
    }
    sscanf(tmp1, "%p", &handle);
    sscanf(tmp2, "%d", &connectionType);
    result =  Aps_PrinterSetConnectInfo(handle, 
                        (Aps_ConnectionType )connectionType, tmp);
    SetResultEditBox(result);

}
/* ---------------------------------------------------------------------------
 * RunPrinterGetMaxJobSize() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_PrinterGetMaxJobSize' item from 
 * the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunPrinterGetMaxJobSize()
{
    Aps_Result  result;
    Aps_Handle  handle;
    char tmp[50];
    int maxSize;

    // Get the value of settings from the edit box 1 for the handle
    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_PrinterGetMaxJobSize", "Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &handle);
    result =  Aps_PrinterGetMaxJobSize(handle, &maxSize);
    if (maxSize == APS_NO_MAX_SIZE)
        editOutput1->setText("APS_NO_MAX_SIZE");
    else {
        sprintf(tmp, "%d", maxSize); 
        editOutput1->setText(tmp);
    }
    SetResultEditBox(result);
}
/* ---------------------------------------------------------------------------
 * RunPrinterSetConfigFlags() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_PrinterSetConfigFlags' item from 
 * the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunPrinterSetConfigFlags()
{
    Aps_Result  result;
    Aps_Handle  handle;
    char tmp1[50], tmp2[50], tmp3[50];
    long int flagsToSet = 0, flagsToReset = 0;

    // Get the value of settings from the edit box 1 for the handle
    strcpy(tmp1, (const char *)editInput1->text());
    strcpy(tmp2, (const char *)editInput2->text());
    strcpy(tmp3, (const char *)editInput3->text());
    if (strcmp(tmp1, "") == 0){
        MessageBox("Testing Aps_PrinterSetConfigFlags", "Handle not Specified");
        return;
    }
    if (!strcmp(tmp2, "") && !strcmp(tmp3, "")){
        MessageBox("Testing Aps_PrinterSetConfigFlags","What to Set/Reset?");
        return;
    }
    sscanf(tmp1, "%p", &handle);
    if (strcmp(tmp2,""))
        sscanf(tmp2, "%ld", &flagsToSet);
    else 
        flagsToSet = 0;

    if (strcmp(tmp3,""))
        sscanf(tmp3, "%ld", &flagsToReset);
    else 
        flagsToReset = 0;
    result =  Aps_PrinterSetConfigFlags(handle, flagsToSet, flagsToReset);
    SetResultEditBox(result);
}
/* ---------------------------------------------------------------------------
 * RunPrinterSetMaxJobSize() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_PrinterSetMaxJobSize' item from 
 * the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunPrinterSetMaxJobSize()
{
    Aps_Result  result;
    Aps_Handle  handle;
    char tmp1[50], tmp2[50];
    int maxSize;

    // Get the value of settings from the edit box 1 for the handle
    strcpy(tmp1, (const char *)editInput1->text());
    strcpy(tmp2, (const char *)editInput2->text());
    if (strcmp(tmp1, "") == 0){
        MessageBox("Testing Aps_PrinterSetMaxJobSize", "Handle not Specified");
        return;
    }
    if (strcmp(tmp2, "") == 0){
        MessageBox("Testing Aps_PrinterSetMaxJobSize", "size not Specified");
        return;
    }
    sscanf(tmp1, "%p", &handle);
    sscanf(tmp2, "%d", &maxSize);
    result =  Aps_PrinterSetMaxJobSize(handle, maxSize);
    SetResultEditBox(result);
}

/* ---------------------------------------------------------------------------
 * RunGetResultText() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_GetResultText' item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunGetResultText()
{
    int  result;
    Aps_Result  ret;
    char  text[512], tmp[20];

    memset(text, 0, 512);
    strcpy(tmp,  (const char *)editInput1->text());
    if ( strcmp(tmp, "") == 0) {
        MessageBox("Testing Aps_GetResultText", "Please Specify Prev Result Code");
        return;
    }
    result = atoi(tmp);
    if (result >= 0) {
        ret = Aps_GetResultText((Aps_Result)result, text, 512);
        editOutput1->setText(text);
        SetResultEditBox(ret);
    }
    else {
        MessageBox("Testing Aps_GetResultText", "The value entered for Result is not correct ");
        editResult->setText("");
        return;
    }
}

/* ---------------------------------------------------------------------------
 * RunOpenDefaultPrinter() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_OpenDefaultPrinter' item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunOpenDefaultPrinter()
{
    Aps_Result  result;
    Aps_PrinterHandle handle = NULL;
    char  tmp[50];

    result = Aps_OpenDefaultPrinter(&handle);
    // Store this handle as the lastPrinterHandle
    lastPrinterHandle = handle;
    //pbExecute->setEnabled(FALSE);
    SetResultEditBox(result);
    // Display the printer handle
    sprintf(tmp, "%p", handle);
    editOutput1->setText(tmp);
}

/* ---------------------------------------------------------------------------
 * RunGetPrinters() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_GetPrinters' item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunGetPrinters()
{
    Aps_Result  result;
    int count;
    char **name, tmp[200];

    result = Aps_GetPrinters(&name, &count);

    // Display the printer names
    *tmp ='\0';
    for(int i = 0; i< count; i++){
        sprintf(tmp + strlen(tmp), "%s%c ", *(name + i), ',');
    }
    editOutput1->setText(tmp);

    // Free the memory allocated for printer names
    // Display the count
    sprintf(tmp, "%d", count);
    editOutput2->setText(tmp);
    Aps_ReleaseBuffer(name);
    
    SetResultEditBox(result);
}

/* ---------------------------------------------------------------------------
 * RunOpenPrinter() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_OpenPrinter' item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunOpenPrinter()
{
    Aps_Result  result ;
    Aps_PrinterHandle handle = NULL;
    char  tmp[50];
    const char *printer;

    printer = (const char *)editInput1->text();

    if (strcmp(printer, "") == 0 ) {
        MessageBox("Testing Aps_OpenPrinter", "Printer Name not specified");
        return;
    }
    result = Aps_OpenPrinter(printer, &handle);
    SetResultEditBox(result);
    // Store this handle as the lastPrinterHandle
    lastPrinterHandle = handle;
    // Display the printer handle
    sprintf(tmp, "%p", handle);
    editOutput1->setText(tmp);
}
/* ---------------------------------------------------------------------------
 * RunAddPrinter() 
 *
 * This method is called when the Execute button is selected from APS 
 * testprogram after selecting the 'Aps_AddPrinter' item from the list.
 * To pass NULL to the printer handle, type null or NULL in the text field.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunAddPrinter()
{
    Aps_Result  result ;
    Aps_PrinterHandle handle;
    char  tmp[50];
    const char *printer, *handleStr;

    printer = (const char *)editInput1->text();
    handleStr = (const char *)editInput2->text();

    if (strcmp(printer, "") == 0 ) {
        MessageBox("Testing Aps_AddPrinter", "Printer Name not specified");
        return;
    }
    if (!strcmp(handleStr, "null"))
    {
       result = Aps_AddPrinter(printer, NULL);
       handle = NULL;
    }
    else 
       result = Aps_AddPrinter(printer, &handle);
    SetResultEditBox(result);
    // Store this handle as the lastPrinterHandle
    if ((result == APS_SUCCESS)&&(handle != NULL))
    {
        lastPrinterHandle = handle;
        // Display the printer handle
        sprintf(tmp, "%p", handle);
        editOutput1->setText(tmp);
     }
     else
        editOutput1->setText("");
}

/* ---------------------------------------------------------------------------
 * RunGetDefaultJobSettings() 
 *
 * This method is called when the Execute button selected from APS 
 * testprogram after selecting the 'Aps_GetDefaultJobSettings' item 
 * from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunGetDefaultJobSettings()
{

}

/* ---------------------------------------------------------------------------
 * RunGetDefaultJobSettings() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_GetDefaultJobSettings' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunSetDefaultJobSettings()
{

}

/* ---------------------------------------------------------------------------
 * RunGetProperty() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_GetProperty' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunGetProperty()
{

}

/* ---------------------------------------------------------------------------
 * RunSetProperty() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_SetProperty' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunSetProperty()
{

}

/* ---------------------------------------------------------------------------
 * RunStartJob() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_StartJob' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunStartJob()
{
    Aps_Result  result;
    Aps_PrinterHandle printer = NULL;
    const char *format = NULL;
    Aps_JobHandle job = NULL;
    char  tmp[200];

    // Get the values of printer, format from the edit boxes
    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "")== 0) {
        MessageBox(" Testing Aps_StartJob", "Printer Handle not specified");
        return;
    }
    sscanf(tmp, "%p", &printer);
    format = (const char *)editInput2->text();
    if (strcmp(format, "") == 0)
        format = NULL;

    result = Aps_PrinterStartJob(printer, (char *)format, &job);
    SetResultEditBox(result);
    // Store the job handle in the data member
    lastJobHandle = job;
    // Display the Job  handle and descriptor
    memset(tmp, 0, 200);
    sprintf(tmp, "%p", job);
    editOutput1->setText(tmp);
    memset(tmp, 0, 200);
    sprintf(tmp, "no descriptor"); /* obsolete!! */
    editOutput2->setText(tmp);
}

/* ---------------------------------------------------------------------------
 * RunGetJobSettings() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_GetJobSettings' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunGetJobSettings()
{
}

/* ---------------------------------------------------------------------------
 * RunWrite() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_Write' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunWrite()
{
    Aps_Result  result;
    Aps_JobHandle job = NULL;
    char *data, tmp[200];
    int  size = 0;

    size = strlen(editInput5->text());
    // Get the values of Job Handle and data
    data = (char *)malloc(size +1);
    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_Write", "Job Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &job);
    strcpy( data,  (const char *) editInput5->text());
    result = Aps_JobWrite(job, data, size);
    free (data) ;
    SetResultEditBox(result);
}

/* ---------------------------------------------------------------------------
 * RunGetJobStat() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_GetJobStat' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunGetJobState()
{
    Aps_Result  result ;
    Aps_JobHandle job;
    Aps_JobStatus  state;
    char tmp[50];

    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_GetJobState", "Job Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &job);
    result = Aps_JobGetStatus(job, &state);
    SetResultEditBox(result);
    // print the value of the state 
    SetJobStateEditBox(state);
}

/* ---------------------------------------------------------------------------
 * RunEndJob() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_EndJob' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunEndJob()
{
    Aps_Result  result ;
    Aps_JobHandle job;
    const char *handleValue;
    int  releaseHandle;
    char tmp[50];

    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_EndJob", "Job Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &job);
    handleValue = editInput2->text();
    if ((strcmp (handleValue, "TRUE") == 0)||
        (strcmp (handleValue, "true") == 0))
        releaseHandle = TRUE;
    else if ((strcmp (handleValue, "FALSE") == 0)||
             (strcmp (handleValue, "false") == 0))
              releaseHandle = FALSE;
    else {
        MessageBox("Aps_CancelJob", "Enter True/False for releaseHandle");	// Invalid releaseHandle
        editResult->setText("");
        return;
    }
    if (! releaseHandle) Aps_AddRef(job);
    result = Aps_JobEnd(job);
    SetResultEditBox(result);
}

/* ---------------------------------------------------------------------------
 * RunGetPrinterName() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_GetPrinterName' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunGetPrinterName()
{
    Aps_Result  result;
    Aps_PrinterHandle handle;
    char *tmp;

    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_GetPrinterName", "Printer Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &handle);
    memset(tmp, 0, 50);
    result = Aps_PrinterGetName(handle, &tmp);
    if (tmp) {
        editOutput1->setText(tmp);
        Aps_ReleaseBuffer(tmp);
    } else editOutput1->setText("<returned null!!>");
    SetResultEditBox(result);
}
/* ---------------------------------------------------------------------------
 * RunGetPPDFilename() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_GetPPDFilename' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunGetPPDFilename()
{
    Aps_Result  result ;
    Aps_PrinterHandle handle = NULL;
    char *fileName;
    char tmp[50];

    strcpy(tmp, (const char *)editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_GetPPDFilename", "Printer Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &handle);
    result = Aps_PrinterGetPPDFileName(handle, &fileName);
    if (fileName) {
        editOutput1->setText(fileName);
        Aps_ReleaseBuffer(fileName);
    } else editOutput1->setText("<returned null!>");
    SetResultEditBox(result);
}
/* ---------------------------------------------------------------------------
 * RunBasicPrinting() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Basic Printing' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunBasicPrinting()
{
    Aps_Result  result;
    Aps_PrinterHandle handle = NULL;
    Aps_JobHandle job = NULL;
/******* These variables will be used to test the StartJob, Write and EndJob sequence
    Aps_JobSettingsHandle settings=NULL;
    int descriptor, fd, ret;
    char *filename;
    char buf[1024];
****************************************/

    result = Aps_OpenDefaultPrinter(&handle);
    //result = Aps_OpenPrinter("SwapanPrint", &handle);
    if (result == APS_SUCCESS)	// OpenDefaultPrinter is successful
    	result = Aps_DispatchJob(handle, (char *) "test1.ps", (char *) "", NULL, &job);
    SetResultEditBox(result);

/**** The following code takes care of the StartJob, Write and EndJob Sequence 
  to be enabled later and put as a seperate test case 

    // This is done temporarily because default printer has to be set first
    result = Aps_OpenPrinter("SwapanPrint", &handle);

    if (result == APS_SUCCESS)	// OpenDefaultPrinter is successful
    {
        result = Aps_StartJob(handle, (char *)"", &job, &descriptor);
        if (result == APS_SUCCESS)
        {
            result = Aps_Write(job, "ABCDEF", 7);
            if (result == APS_SUCCESS)
            {
                // Because some printers accept only postscript file
                //result = Aps_EndJob(job, 1);
    result = Aps_DispatchJob(handle, (char *) "test1.ps", (char *) "", NULL, &job);
            }
        }
    }
    SetResultEditBox(result);
*************************************************************/

}
/* ---------------------------------------------------------------------------
 * RunCancelJob() 
 *
 * This method is called when the Execute button is selected from 
 * APS testprogram after selecting the 'Aps_CancelJob' 
 * item from the list.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::RunCancelJob()
{
    Aps_Result  result ;
    Aps_JobHandle job;
    const char *handleValue;
    int  releaseHandle;
    char tmp[50];

    strcpy(tmp, editInput1->text());
    if (strcmp(tmp, "") == 0){
        MessageBox("Testing Aps_CancelJob", "Job Handle not Specified");
        return;
    }
    sscanf(tmp, "%p", &job);
    handleValue = (const char *)editInput2->text();
    if ((strcmp (handleValue, "TRUE") == 0)||
        (strcmp (handleValue, "true") == 0))
        releaseHandle = TRUE;
    else if ((strcmp (handleValue, "FALSE") == 0)||
             (strcmp (handleValue, "false") == 0))
            releaseHandle = FALSE;
    else {
        MessageBox("Aps_CancelJob", "Enter True/False for releaseHandle");	// Invalid releaseHandle
        editResult->setText("");
        return;
    }
    if (! releaseHandle) Aps_AddRef(job); /* So we can keep monitoring it */
    result = Aps_JobAbort(job);
    SetResultEditBox(result);
}

/* ---------------------------------------------------------------------------
 * SetResultEditBox() 
 *
 * This method is called to set the 'Return Code' in the Result
 * Edit field for the APS call tested.
 *
 * Parameters: void
 *
 *     Return: void
 */           
void TestAps::SetResultEditBox(int result)
{
    char *message = NULL;

    switch (result) {
        case APS_SUCCESS :
                message = "APS_SUCCESS";
                break;
        case APS_NOT_IMPLEMENTED :
                message = "APS_NOT_IMPLEMENTED";
                break;
        case APS_NOT_SUPPORTED :
                message = "APS_NOT_SUPPORTED";
                break;
        case APS_INVALID_PARAM :
                message = "APS_INVALID_PARAM";
                break;
        case APS_MORE_DATA :
                message = "APS_MORE_DATA";
                break;
        case APS_OUT_OF_MEMORY :
                message = "APS_OUT_OF_MEMORY";
                break;
        case APS_NOT_FOUND :
                message = "APS_NOT_FOUND";
                break;
        case APS_ACCESS_DENIED :
                message = "APS_ACCESS_DENIED";
                break;
        case APS_INVALID_HANDLE :
                message = "APS_INVALID_HANDLE";
                break;
        case APS_GENERIC_FAILURE :
                message = "APS_GENERIC_FAILURE";
                break;
        case APS_DISK_FULL :
                message = "APS_DISK_FULL";
                break;
        case APS_INVALID_PWD :
                message = "APS_INVALID_PWD";
                break;
        case APS_OUT_OF_SEQUENCE :
                message = "APS_OUT_OF_SEQUENCE";
                break;
        case APS_ALREADY_EXISTS :
                message = "APS_ALREADY_EXISTS";
                break;
        case APS_NO_CHANGE :
                message = "APS_NO_CHANGE";
                break;
    }
    if (message != NULL)
    editResult->setText(message);
}
/* ---------------------------------------------------------------------------
 * SetJobStateEditBox() 
 *
 * This method is called to set the 'Job State' in the Job State
 * Edit field for the 'Aps_GetJobState' tested.
 *
 * Parameters: Aps_JobState
 *
 *     Return: void
 */           
void TestAps::SetJobStateEditBox(Aps_JobStatus state)
{
    char *message = NULL;

    switch (state) {
        case APS_JOB_SETUP: message = "APS_JOB_SETUP"; break;
        case APS_JOB_SPOOLING: message = "APS_JOB_SPOOLING"; break;
        case APS_JOB_QUEUEING: message = "APS_JOB_QUEUEING"; break;
        case APS_JOB_PENDING: message = "APS_JOB_PENDING"; break;
        case APS_JOB_SENDING: message = "APS_JOB_SENDING"; break;
        case APS_JOB_PRINTING: message = "APS_JOB_PRINTING"; break;
        case APS_JOB_PAUSED: message = "APS_JOB_PAUSED"; break;
        case APS_JOB_SUSPENDED: message = "APS_JOB_SUSPENDED"; break;
        case APS_JOB_COMPLETED: message = "APS_JOB_COMPLETED"; break;
        case APS_JOB_STORED: message = "APS_JOB_STORED"; break;
        case APS_JOB_FAILED: message = "APS_JOB_FAILED"; break;
        case APS_JOB_ABORTED: message = "APS_JOB_ABORTED"; break;
        case APS_JOB_CANCELLED: message = "APS_JOB_CANCELLED"; break;
        case APS_JOB_DISCARDED: message = "APS_JOB_DISCARDED"; break;
        case APS_JOB_INVALID: message = "APS_JOB_INVALID"; break;
        default: message = "composite state??";
    }
    editOutput1->setText(message);
}

/* ---------------------------------------------------------------------------
 * MessageBox() 
 *
 * This method is called to display the message box. 
 * 
 *
 * Parameters: char *, char *
 *
 *     Return: void
 */           
void TestAps::MessageBox(char *caption, char  *message )
{ 
    QMessageBox *mb = new QMessageBox(this);
    mb->setCaption(caption);
    mb->setText(message);
    mb->setIcon(QMessageBox::Information);
    mb->setButtonText(0, "OK");
    mb->exec();
    delete mb;
}

/* ---------------------------------------------------------------------------
 * SetPrevHandle() 
 *
 * This method is called to display the value of the handles obtained 
 * from the previous APS calls
 *
 * Parameters: int
 *
 *     Return: void
 */           
void TestAps::SetPrevHandles(int index)
{ 
    char printerHandle[20];
    char jobHandle[20];
    char settingsHandle[20];

    memset (printerHandle, 0, 20);
    memset (jobHandle, 0, 20);
    memset (settingsHandle, 0, 20);

    if (lastPrinterHandle != NULL)
        sprintf(printerHandle, "%p", lastPrinterHandle); 

    if (lastJobHandle != NULL)
        sprintf(jobHandle, "%p", lastJobHandle); 

    switch (index){
        case 0 :
                editInput1->setText(printerHandle);
	        break;
        case 1 :
                editInput1->setText(printerHandle);
	        break;
        case 2 :
	        break;
        case 3 :
	        break;
        case 4 :
	        break;
        case 5 :
	        break;
        case 6 :
	        break;
        case 7 :
	        break;
        case 8 :
	        break;
        case 9 :
	        break;
        case 10 :
                editInput1->setText(printerHandle);
	        break;
        case 11 :
	        break;
        case 12 :
                editInput1->setText(jobHandle);
	        break;
        case 13 :
                editInput1->setText(jobHandle);
	        break;
        case 14 :
                editInput1->setText(jobHandle);
	        break;
        case 15 :
                editInput1->setText(jobHandle);
	        break;
        case 16 :
                editInput1->setText(printerHandle);
                break;
        case 17 :
                editInput1->setText(printerHandle);
                break;
        case 18 :
                editInput1->setText(printerHandle);
                break;
        case 19 :
                break;
        case 20 :
                editInput1->setText(printerHandle);
                break;
        case 21 :
                editInput1->setText(printerHandle);
                break;
        case 22 :
                editInput1->setText(printerHandle);
                break;
        case 23 :
                editInput1->setText(printerHandle);
                break;
        case 24 :
                editInput1->setText(printerHandle);
                break;
        case 25 :
                editInput1->setText(printerHandle);
                break;
        case 26 :
                editInput1->setText(printerHandle);
                break;
        case 27 :
                editInput1->setText(printerHandle);
                break;
        case 28 :
                editInput1->setText(printerHandle);
                break;
        default :
                break;
    }
}
