#include <klocale.h>
#include <kconfig.h>
#include <kcompletion.h>
#include <klineedit.h>
#include <kdebug.h>
#include <knotifyclient.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qvaluelist.h>
#include <klistview.h>
#include "kab3viewcontainer.h"
#include "kab3mainwidget.h"
#include "kab3mainwidget.moc"
#include "kab3global.h"
#include "look_details.h"

Kab3MainWidget::Kab3MainWidget(KABC::AddressBook *ab_,
                               QWidget* parent,  const char* name)
    : Kab3MainWidgetBase( parent, name),
      modified(false),
      m_ab(ab_)
{
    viewTree->addColumn(i18n("Contact"));
    // -----
    m_details=viewContainer->detailledView;
    kdDebug() << "Kab3MainWidget ctor: view is "
              << m_details << endl;
    connect(this, SIGNAL(readonlyChanged(bool)),
            m_details, SLOT(setReadonly(bool)));
    connect(m_details, SIGNAL(entryChanged()),
            SLOT(slotEntryChanged()));
    // ----- set size relations to 50/50, dunno if this is the
    // intended use but works fine:
    QValueList<int> sizes;
    sizes.append(1); sizes.append(1);
    splitter->setSizes(sizes);
    // ----- set up the incremental search map:
    timerIndex=new QTimer(this);
    connect(timerIndex, SIGNAL(timeout()), SLOT(slotMakeSearchIndex()));
    // -----
    patterns.setAutoDelete(true);
}

Kab3MainWidget::~Kab3MainWidget()
{
}

void Kab3MainWidget::slotContactSelected(QListViewItem *i)
{
    // ----- save possible changes:
    if(modified)
    {
        commit();
    }
    // ----- find out about the ID of the selected entry:
    Kab3ListViewItem *item=(Kab3ListViewItem*)i;
    KABC::Addressee addressee=m_ab->findByUid(item->id());
    // ----- display it:
    m_details->setEntry(addressee);
    modified=false;
}

Kab3ListViewItem::Kab3ListViewItem(QListView *parent, const KABC::Addressee& a)
    : QListViewItem(parent),
      m_contact(a)
{
    setText(0, m_contact.realName());
}


QString Kab3ListViewItem::id()
{
    return m_contact.uid();
}

KABC::Addressee Kab3ListViewItem::addressee()
{
    return m_contact;
}

void Kab3MainWidget::slotEntryChanged()
{
    kdDebug() << "Kab3MainWidget::slotEntryChanged: addressee modified." << endl;
    modified=true;
    emit(databaseModified());
}

void Kab3MainWidget::slotAddressBookChanged(KABC::AddressBook *ab)
{
    // ab should in fact be m_ab:
    KABC::AddressBook::Iterator it;
    viewTree->clear();
    listViewItems.clear();
    QListViewItem *first;
    for(it=ab->begin(); it!=ab->end(); ++it)
    {
        listViewItems.append(new Kab3ListViewItem(viewTree, *it));
    }
    first=viewTree->firstChild();
    viewTree->setCurrentItem(first);
    slotContactSelected(first);
    leSearch->setEnabled(false);
    leSearch->setText(i18n("..."));
    leSearch->setCursor(waitCursor);
    timerIndex->start(500, true);
}

void Kab3MainWidget::slotMakeSearchIndex()
{
    leSearch->setText(i18n("Calculating..."));
    KCompletion *comp;
    int count=0;
    bool avail=false;
    KABC::AddressBook::Iterator it;
    QString text, realname, familyName, givenName, addName, formattedName, nick;
    QStringList emails;
    KABC::PhoneNumber::List phones;
    // ----- create the lookup index first:
    for(it=m_ab->begin(); it!=m_ab->end(); ++it)
    {
        realname=(*it).realName();
        if(!realname.isEmpty())
        {
            patterns.append(new Pattern(realname, realname, (*it).uid()));
        }
        familyName=(*it).familyName();
        if(!familyName.isEmpty())
        {
            patterns.append(new Pattern(familyName, realname, (*it).uid()));
        }
        givenName=(*it).givenName();
        if(!givenName.isEmpty())
        {
            patterns.append(new Pattern(givenName, realname, (*it).uid()));
        }
        addName=(*it).additionalName();
        if(!addName.isEmpty())
        {
            patterns.append(new Pattern(addName, realname, (*it).uid()));
        }
        formattedName=(*it).formattedName();
        if(!formattedName.isEmpty())
        {
            patterns.append(new Pattern(formattedName, realname, (*it).uid()));
        }
        nick=(*it).nickName();
        if(!nick.isEmpty())
        {
            patterns.append(new Pattern(nick, realname, (*it).uid()));
        }
        emails=(*it).emails();
        for(unsigned i=0; i<emails.count(); ++i)
        {
            text=emails[i];
            if(!text.isEmpty())
            {
                patterns.append(new Pattern(text, realname, (*it).uid()));
            }
        }
        phones=(*it).phoneNumbers();
        for(unsigned i=0; i<phones.count(); ++i)
        {
            text=phones[i].number();
            if(!text.isEmpty())
            {
                patterns.append(new Pattern(text, realname, (*it).uid()));
            }
        }
        ++count;
    }
    patterns.sort();
    avail=!patterns.isEmpty();
    leSearch->setText(avail ? QString("") : i18n("No items to search)"));
    leSearch->setEnabled(avail);
    leSearch->setCursor(avail ? arrowCursor : forbiddenCursor);
    // ----- put it's contents in the completion object:
    comp=leSearch->completionObject();
    comp->setIgnoreCase(true);
    for(unsigned int i=0; i<patterns.count(); ++i)
    {
        comp->addItem(patterns.at(i)->key());
    }
}

void Kab3MainWidget::slotPatternEntered(const QString& pattern)
{
    unsigned count;
    QString uid;
    // ----- first find the pattern that was selected in the patterns index:
    for(count=0; count<patterns.count(); ++count)
    {
        if(patterns.at(count)->key()==pattern) break;
    }
    if(count==patterns.count())
    {
        KNotifyClient::beep();
    } else {
        // ----- now find the item in the list attached to it:
        uid=patterns.at(count)->uid();
        Kab3ListViewItem* item;
        for(item=listViewItems.first(); item; item=listViewItems.next())
        {
            if(item->id()==uid) break;
        }
        if(item)
        {
            viewTree->setSelected(item, true);
        }
    }
}

void Kab3MainWidget::init(KConfig *config)
{
    m_details->configure(config);
}

void Kab3MainWidget::commit()
{
    m_ab->insertAddressee(m_details->entry());
    modified=false;
}
