
#ifndef |NAMEBIG|VIEW_H
#define |NAMEBIG|VIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>

class |NAME|Doc;

/** The |NAME|View class provides the view widget for the document instance connected to it and is displayed
 * as a MDI child window in the main view area of the |NAME|App class instance. The |NAME|App class also has an eventFilter()
 * method that gets installed on every |NAME|View instance to control events of the type QEvent::Close.	
 * The document connected to the view instance keeps a list of all view that represent the document contents as there
 * can be more than one view. Views get created in |NAME|App::createClient() and automatically added to the list of views.
 * The |NAME|View class inherits QWidget as a base. Another possible inheritance besides specialized widgets could be
 * QMainWindow so that you can easily set up the main area of your view by setting another view
 * as main widget (QMainWindow::setMainWidget() ).
 * NOTE: The close event always has to be empty (DON`T CALL QWidget::closeEvent(e) in closeEvent()) because the installed
 * event filter can only manage a forward implementation. If the QCloseEvent is received by the |NAME|View, the overwritten
 * event handler has to do nothing as the eventFilter has set accept() or ignore() already. If QWidget::closeEvent() is called
 * again, the default event handler will accept the close event and the window gets destroyed even if the installed eventFilter
 * has set the event to be ignored.	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 1.3 code generation
 */
class |NAME|View : public QWidget
{
  Q_OBJECT

  friend |NAME|Doc;

  public:
    /** Constructor for the view
    	* @param pDoc  your document instance that the view represents. Create a document before calling the constructor
    	* or connect an already existing document to a new MDI child widget.*/
    |NAME|View(|NAME|Doc* pDoc, QWidget* parent, const char *name, int wflags);
    /** Destructor for the main view */
    ~|NAME|View();
		/** returns a pointer to the document connected to the view*/
    |NAME|Doc *getDocument() const;
    /** gets called to redraw the document contents if it has been modified */
		void update(|NAME|View* pSender);
    /** contains the implementation for printing functionality and gets called by |NAME|App::slotFilePrint() */
    void print(QPrinter *pPrinter);
		
  protected:
    /** overwritten QWidget::closeEvent() to catch closing views. Does nothing, as the closeEvents for
    * |NAME|View's are processed by |NAME|App::eventFilter(), so this overwitten closeEvent is necessary
    * and has to be empty. Don't overwrite this method !
    */
    virtual void closeEvent(QCloseEvent* e);
	  /** The document connected to the view, specified in the constructor */
	  |NAME|Doc *doc;
};

#endif // |NAMEBIG|VIEW_H
