/***************************************************************************
                          kscribbleview.h  -  description
                             -------------------
    begin                : Mon Jan 31 11:05:05 CET 2000
    copyright            : (C) 2000 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSCRIBBLEVIEW_H
#define KSCRIBBLEVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qscrollview.h>
#include <kpixmap.h>

class KScribbleDoc;

/** The KScribbleView class provides the view widget for the document instance connected to it and is displayed
 * as a MDI child window in the main view area of the KScribbleApp class instance. The KScribbleApp class also has an eventFilter()
 * method that gets installed on every KScribbleView instance to control events of the type QEvent::Close.	
 * The document connected to the view instance keeps a list of all view that represent the document contents as there
 * can be more than one view. Views get created in KScribbleApp::createClient() and automatically added to the list of views.
 * The KScribbleView class inherits QWidget as a base. Another possible inheritance besides specialized widgets could be
 * QMainWindow so that you can easily set up the main area of your view by setting another view
 * as main widget (QMainWindow::setMainWidget() ).
 * NOTE: The close event always has to be empty (DON`T CALL QWidget::closeEvent(e) in closeEvent()) because the installed
 * event filter can only manage a forward implementation. If the QCloseEvent is received by the KScribbleView, the overwritten
 * event handler has to do nothing as the eventFilter has set accept() or ignore() already. If QWidget::closeEvent() is called
 * again, the default event handler will accept the close event and the window gets destroyed even if the installed eventFilter
 * has set the event to be ignored.	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 1.1 code generation
 */
class KScribbleView : public QScrollView
{
  Q_OBJECT

  friend KScribbleDoc;

  public:
    /** Constructor for the view
    	* @param pDoc  your document instance that the view represents. Create a document before calling the constructor
    	* or connect an already existing document to a new MDI child widget.*/
    KScribbleView(KScribbleDoc* pDoc, QWidget* parent, const char *name, int wflags);
    /** Destructor for the main view */
    ~KScribbleView();
		/** returns a pointer to the document connected to the view*/
    KScribbleDoc *getDocument() const;
    /** gets called to redraw the document contents if it has been modified */
		void update(KScribbleView* pSender);
    /** contains the implementation for printing functionality and gets called by KScribbleApp::slotFilePrint() */
    void print(QPrinter *pPrinter);
    /** cuts out a selection */
    void cutSelection();
    /** copies a selection to the clipboard */
    void copySelection();
    /** pastes the clipboard contents to a selection that can be inserted into the picture */
    void pasteSelection();
		
  protected:
	
    /** overwritten QWidget::closeEvent() to catch closing views. Does nothing, as the closeEvents for
    * KScribbleView's are processed by KScribbleApp::eventFilter(), so this overwitten closeEvent is necessary
    * and has to be empty. Don't overwrite this method !
    */
    virtual void closeEvent(QCloseEvent* );
    /** overwritten to interpret key events for scrollbars */
    virtual void keyPressEvent( QKeyEvent* );
  	/** changed from mousePressEvent() overwriting QScrollView method */
  	virtual void viewportMousePressEvent( QMouseEvent* );
  	/** changed from mouseReleaseEvent() overwriting QScrollView method */
  	virtual void viewportMouseReleaseEvent( QMouseEvent* );
    /** On paste actions inserts the pasted clipboard contents */
    virtual void viewportMouseDoubleClickEvent(QMouseEvent* e);
  	/** changed from mouseMoveEvent() overwriting QScrollView method */
  	virtual void viewportMouseMoveEvent( QMouseEvent* );
  	/** changed from resizeEvent() overwriting QScrollView method */
//  	virtual void viewportResizeEvent( QResizeEvent* );
  	/** changed from paintEvent() overwriting QScrollView method */
  	virtual void viewportPaintEvent( QPaintEvent* );
	
    virtual void viewportDragEnterEvent ( QDragEnterEvent * );

    virtual void viewportDragMoveEvent ( QDragMoveEvent * );

    virtual void viewportDragLeaveEvent ( QDragLeaveEvent * );

    virtual void viewportDropEvent ( QDropEvent * );
	
	  /** the document instance */
	  KScribbleDoc *doc;
  		
  private:
    KPixmap tmp;
    QRect select;
    QClipboard *cb;
    enum Action{IDLE=0, DRAW, SELECT, PASTE, DRAG} action;
};

#endif // KSCRIBBLEVIEW_H
