/* -*- C++ -*-

  $Id: ShearCmd.h,v 1.3 2000/07/28 20:11:48 wtrobin Exp $

  This file is part of KIllustrator.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef ShearCmd_h_
#define ShearCmd_h_

#include <Command.h>

/**
 * Shears the selected objects of the given document <tt>doc</tt>
 * around the position <tt>center</tt> by the values of <tt>x</tt>
 * and <tt>y</tt>.
 */
class ShearCmd : public ObjectManipCmd {
  Q_OBJECT
public:
  ShearCmd (GDocument* doc, const Coord& center, float x, float y);

  void execute ();

private:
  Coord rcenter;
  float sx, sy;
};

#endif
