/*
 * Copyright (c) 2000-2001, Stockholms Universitet
 * (Stockholm University, Stockholm Sweden)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the university nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: kpam_opt.c,v 1.10 2002/09/19 14:33:38 lha Exp $ */

#include "config.h"

#include <string.h>

#include <security/pam_appl.h>
#include <security/pam_modules.h>

#include "kpam_opt.h"
#include "kpam_log.h"

void
parse_options(kpam_opt *kopt, int argc, const char **argv) 
{
	int i;

	free_options_contents(kopt);
	kopt->root_inst="root";

	for (i = 0; i < argc; i++) {
		if (strcmp("debug", argv[i]) == 0 ) {
			kopt->debug = 1;
		} else if (strcmp("silent", argv[i]) == 0) {
			kopt->silent = 1;
		} else if (strcmp("forwardable", argv[i]) == 0) {
			kopt->forwardable = 1;
		} else if (strcmp("no_afs", argv[i]) == 0) {
			kopt->no_afs = 1;
		} else if (strcmp("no_krb4", argv[i]) == 0) {
			kopt->no_krb4 = 1;
		} else if (strcmp("no_root", argv[i]) == 0) {
			kopt->no_root=1;
		} else if (strcmp("try_first_pass", argv[i]) == 0) {
			kopt->try_first_pass = 1;
		} else if (strcmp("use_first_pass", argv[i]) == 0) {
			kopt->use_first_pass = 1;
		} else if (strcmp("afs_aquire_pag", argv[i]) == 0) {
			kopt->afs_aquire_pag = 1;
		} else if (strncmp("realm=", argv[i], 6) == 0) {
			kopt->realm = argv[i] + 6;
		} else if (strncmp("root_inst=", argv[i], 10) == 0) {
			kopt->root_inst = argv[i] + 10;
		} else
			kpam_syslog(kopt, LOG_ALERT, "Unknown configuration directive: %s", argv[i]);
	}
}

void
free_options_contents(kpam_opt *kopt)
{
	kopt->root_inst = NULL;
	kopt->debug
		= kopt->silent
		= kopt->forwardable
		= kopt->no_afs
		= kopt->no_krb4
		= kopt->afs_aquire_pag
		= kopt->no_root
		= kopt->try_first_pass
		= kopt->use_first_pass
		= 0;
}
