/*
 * Copyright (c) 2000 - 2002, Stockholms Universitet
 * (Stockholm University, Stockholm Sweden)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the university nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: krb_stuff.h,v 1.9 2003/10/01 00:57:22 lha Exp $
 *
 * SYNOPSIS
 *
 * #include "config.h"
 * #include <pwd.h>
 * #include <krb5.h>
 * #include "kpam_opt.h"
 *#include "krb_stuff.h"
 */

#ifndef KRB_STUFF_H
#define KRB_STUFF_H

#define KPAM_USED_CONTEXT   0x01
#define KPAM_USED_CCACHE    0x02
#define KPAM_USED_PRINCIPAL 0x04
#define KPAM_USED_CREDS     0x08
#define KPAM_USED_K4TMP     0x10
#define KPAM_USED_K5TMP     0x20

#define BUFSIZE 80

typedef struct krb_stuff_s {
	char k5tmp_file[BUFSIZE];
#ifdef USE_KRB4
	char k4tmp_file[BUFSIZE];
#endif
	krb5_context context;
	krb5_principal princ;
	krb5_ccache ccache;
	krb5_creds cred;
        krb5_error_code auth_failed;
	int used;
} krb_stuff;

int init_krb_stuff(krb_stuff *kstuff, kpam_opt *kopt);

void free_used_krb_stuff(krb_stuff *kstuff, const kpam_opt *kopt);

int krb_kauth(krb_stuff *kstuff, const kpam_opt *kopt,
    const struct passwd *pwd, const char *pname, const char *pass);

#ifdef USE_AFS
void
kpam_create_afs_tokens(krb5_context,const kpam_opt *,const struct passwd *);

#endif

void
kpam_copy_cc_to_new_name(pam_handle_t *pamh, const kpam_opt *kopt,
			 krb5_context context, struct passwd *pwd);


#endif
