/*
 * This file is part of libdissipate, an open source SIP library.  Please see
 * http://www.div8.net/dissipate for more information.
 *
 * Copyright (c) 2000 Billy Biggs <bbiggs@div8.net>
 *
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */

#ifndef GENERALURI_H_INCLUDED
#define GENERALURI_H_INCLUDED

#include <qstring.h>

/**
 * @short	Simple URI base class.
 * @author	Billy Biggs <bbiggs@div8.net>
 *
 * This class provides a simple base class for defining URIs.
 */
class GeneralUri
{
public:
	GeneralUri( void );
	virtual ~GeneralUri( void );

	/**
	 * Returns the protocol name of the URI.  For example, an http URI has
	 * a protocol name of 'http'.
	 */
	virtual QString getProtocolName( void );

	/**
	 * Returns the entire URI, including protocol name and full path.
	 */
	virtual QString uri( void );

private:
	QString uridata;
};

#endif // GENERALURI_H_INCLUDED
