#include <stdio.h>
#include <sdp.h>

const SdpMessage SdpMessage::null;

SdpMessage::SdpMessage( void )
{
	valid = true;
	port = 0;
	videoPort = 0;
}

SdpMessage::SdpMessage( const QString &parseinput )
{
	parseInput( parseinput );
}

SdpMessage::~SdpMessage( void )
{
}

void SdpMessage::setIpAddress( const QString &newaddr )
{
	ipaddress = newaddr;
}

void SdpMessage::setPort( unsigned int newport )
{
	port = newport;
}

void SdpMessage::setVideoPort( unsigned int newport )
{
	videoPort = newport;
}

void SdpMessage::setName( const QString &newname )
{
	sessionname = newname;
}

QString SdpMessage::message( codecType c, codecType v, QString body ) const
{
	QString msg;

	// Version
	msg += "v=0\r\n";

	// Session Id
	msg += "o=username 0 0 IN IP4 " + ipaddress + "\r\n";

	// Session Name
	msg += "s=" + sessionname + "\r\n";

	// Connection Info
	msg += "c=IN IP4 " + ipaddress + "\r\n";

	// Time active
	msg += "t=0 0\r\n";

	// Media information
	QString ulaw = " 0";
	QString gsm = " 3";
	QString ilbc = "97";
	QString h261 = "31";
	QString h263 = "34";
	if( !body.isEmpty() ) {
		if( body.contains( "m=audio" ) ) {
			QString m = body.mid( body.find( "m=audio" ) + 7 );
			m = m.left( m.find( "\n" ) );
			m = m.mid( m.find( "RTP/AVP" ) + 7 );
			m += " ";
			if( !m.contains( " 0 " ) ) {
				ulaw = "";
			}
			if( !m.contains( " 3 " ) ) {
				gsm = "";
			}
			ilbc = "";
			if( body.lower().contains( "ilbc/8000" ) ) {
				ilbc = body.lower().mid( body.lower().find( "ilbc/8000" ) - 7, 6 );
				if( ilbc.contains( ":" ) ) {
					ilbc = ilbc.mid( ilbc.find( ":" ) + 1 );
				}
				ilbc = ilbc.simplifyWhiteSpace();
			}
		}
		if( body.contains( "m=video" ) ) {
			QString m = body.mid( body.find( "m=video" ) + 7 );
			m = m.left( m.find( "\n" ) );
			m = m.mid( m.find( "RTP/AVP" ) + 7 );
			m += " ";
			if( !m.contains( " 31 " ) ) {
				h261 = "";
			}
			if( !m.contains( " 34 " ) ) {
				h263 = "";
			}
		}
	}
	switch( c ) {
		case codecGSM:
			msg += "m=audio " + QString::number( port ) + " RTP/AVP 3 " + ilbc + ulaw + "\r\n";
			break;
		case codecILBC:
			msg += "m=audio " + QString::number( port ) + " RTP/AVP " + ilbc + gsm + ulaw + "\r\n";
			break;
		default:
			msg += "m=audio " + QString::number( port ) + " RTP/AVP 0 " + ilbc + gsm + "\r\n";
	}

	if( !ulaw.isEmpty() ) {
		msg += "a=rtpmap:0 PCMU/8000\r\n";
		//more fixes for nortel
		//msg += "a=ptime:20\r\n";
	}
	if( !gsm.isEmpty() ) {
		msg += "a=rtpmap:3 GSM/8000\r\n";
	}
	if( !ilbc.isEmpty() ) {
		msg += "a=rtpmap:" + ilbc + " iLBC/8000\r\n";
	}

	switch( v ) {
		case codecH261:
			msg += "m=video " + QString::number( videoPort ) + " RTP/AVP 31 " + h263 + "\r\n";
			break;
		case codecH263:
			msg += "m=video " + QString::number( videoPort ) + " RTP/AVP 34 " + h261 + "\r\n";
			break;
		default:
			break;
	}
	if( v != codecUnknown ) {
		if( !h261.isEmpty() ) {
			msg += "a=rtpmap:31 H261/90000\r\n";
		}
		if( !h263.isEmpty() ) {
			msg += "a=rtpmap:34 H263/90000\r\n";
		}
	}

	return msg;
}

void SdpMessage::parseInput( const QString &parseinput )
{
	QString input = parseinput;
	QString curline;
	QString portstr;
	QString codecstr;
	valid = false;

	port = 0;
	videoPort = 0;
	ipaddress = QString::null;

	// Guarentee termination
	input += '\n';

	if( input.left( input.find( '\n' ) ) != "v=0" ) {
		return;
	}
	input.remove( 0, input.find( '\n' ) + 1 );

	while( input.length() > 0 ) {
		curline = input.left( input.find( '\n' ) );
		input.remove( 0, input.find( '\n' ) + 1 );

		if( curline.left( curline.find( '=' ) ) == "c" ) {
			ipaddress = curline.mid( curline.find( "IP4" ) + 4 ).stripWhiteSpace();
		}
		if( curline.left( curline.find( "=audio" ) ) == "m" ) {
			portstr = curline.mid( curline.find( "audio" ) + 5 );
			portstr = portstr.left( portstr.find( "RTP" ) ).stripWhiteSpace();

			// fix for ericsson
			if( portstr.contains( '/' ) ) {
				printf( "SdpMessage: Uh-oh, ericsson is calling again\n" );
				portstr = portstr.left( portstr.find( '/' ) ).stripWhiteSpace();
				printf( "SdpMessage: portstr is '%s'\n", portstr.latin1() );
			}
			port = portstr.toUInt();
		}

		if( curline.left( curline.find( "=video" ) ) == "m" ) {
			portstr = curline.mid( curline.find( "video" ) + 5 );
			portstr = portstr.left( portstr.find( "RTP" ) ).stripWhiteSpace();

			// fix for ericsson
			if( portstr.contains( '/' ) ) {
				printf( "SdpMessage: Uh-oh, ericsson is calling again\n" );
				portstr = portstr.left( portstr.find( '/' ) ).stripWhiteSpace();
				printf( "SdpMessage: portstr is '%s'\n", portstr.latin1() );
			}
			videoPort = portstr.toUInt();
		}
	}

	valid = true;
}

bool SdpMessage::operator==( const SdpMessage &m ) const
{
	return ( ( ipaddress == m.ipaddress ) && ( port == m.port ) );
}

bool SdpMessage::operator!=( const SdpMessage &m ) const
{
	return !( *this == m );
}

SdpMessage &SdpMessage::operator=( const SdpMessage &m )
{
	valid = m.valid;
	sessionname = m.sessionname;
	ipaddress = m.ipaddress;
	port = m.port;
	videoPort = m.videoPort;

	return *this;
}

bool SdpMessage::isOnHold( void ) const
{
	return ( ipaddress.simplifyWhiteSpace() == "0.0.0.0" );
}

