#include <sipurilist.h>

const SipUriList SipUriList::null;

SipUriList::SipUriList( void )
{
}

SipUriList::SipUriList( const QString &parseinput )
{
	parseList( parseinput );
}

SipUriList::~SipUriList( void )
{
}

QString SipUriList::getUriList( void )
{
	QValueList<SipUri>::Iterator it;
	QString list;
	bool first = true;

	for( it = urilist.begin(); it != urilist.end(); ++it ) {
		if( !first ) {
			list += ", ";
		}

		list += (*it).nameAddr();
		first = false;
	}
	return list;
}

QString SipUriList::getReverseOrderList( void )
{
	QValueList<SipUri>::Iterator it;
	QString list;
	bool first = true;

	for( it = urilist.end(); it != urilist.begin(); --it ) {
		if( !first ) {
			list += ", ";
		}

		list += (*it).nameAddr();
		first = false;
	}
	return list;
}

void SipUriList::parseList( const QString &input )
{
	QString inputline;
	QString cururi;
	unsigned int i = 0;

	inputline = input.simplifyWhiteSpace();

	while( i < inputline.length() ) {

		if( inputline[ i ] == QChar::null ) {
			break;
		} else if( inputline[ i ] == ',' ) {
			cururi = inputline.left( i );
			urilist.append( SipUri( cururi ) );
			inputline.remove( 0, i + 1 );
			inputline.simplifyWhiteSpace();
			i = 0;
		} else if( inputline[ i ] == '<' ) {
			while( i < inputline.length() && inputline[ i ] != '>' ) i++;
		} else if( inputline[ i ] == '\"' ) {
			i++;
			while( i < inputline.length() && inputline[ i ] != '\"' ) i++;
			i++;
		} else {
			i++;
		}
	}

	if( i > 0 ) urilist.append( SipUri( inputline ) );
}

void SipUriList::addToHead( const SipUri &uri )
{
	urilist.prepend( uri );
}

void SipUriList::addToEnd( const SipUri &uri )
{
	urilist.append( uri );
}

void SipUriList::removeHead( void )
{
	urilist.remove( urilist.begin() );
}

SipUri SipUriList::getHead( void ) const
{
	return urilist.first();
}

SipUriList &SipUriList::operator=( const SipUriList &u )
{
	urilist = u.urilist;
	return *this;
}

SipUriList &SipUriList::reverseList( void )
{
	QValueList<SipUri>::Iterator it;
	QValueList<SipUri> templist;

	for( it = urilist.begin(); it != urilist.end(); ++it ) {
		templist.prepend( (*it) );
	}

	urilist = templist;
	return *this;
}

