#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/ip.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <stdio.h>
#include <unistd.h>
#include <strings.h>
#include <udpmessagesocket.h>


UDPMessageSocket::UDPMessageSocket( void )
{
	type = SocketUDP;
	if ( ( socketfd = socket( AF_INET, SOCK_DGRAM, 0 ) ) == -1 ) {
		perror( "UDPMessageSocket::UDPMessageSocket(): socket() failed" );
	}
	didcomplain = false;
}


UDPMessageSocket::UDPMessageSocket( int newfd )
{
	type = SocketUDP;
	socketfd = newfd;
	didcomplain = false;
}


UDPMessageSocket::~UDPMessageSocket( void )
{
	close( socketfd );
}


int UDPMessageSocket::connect( unsigned int portnum )
{
	socketaddress.sin_family = AF_INET;
	socketaddress.sin_port = htons( portnum );
	socketaddress.sin_addr = *( (struct in_addr *) he->h_addr );
	bzero( &(socketaddress.sin_zero), 8 ); // is this portable?
	remoteaddress = socketaddress;
	return 0;
}


int UDPMessageSocket::SetTOS( void )
{
	unsigned char tos;
	socklen_t optlen;
	tos=IPTOS_PREC_CRITIC_ECP;
	optlen=1;
	if(setsockopt(socketfd,SOL_IP,IP_TOS,&tos,optlen) != 0){
		perror("UDPMessageSocket::SetTOS");
	}
	return 0;
}


int UDPMessageSocket::send( const char *sendbuffer, unsigned int length )
{
	int numbytes;
	if ( ( numbytes = sendto( socketfd, sendbuffer, length, 0, (struct sockaddr *) &remoteaddress,
			sizeof( struct sockaddr ) ) ) == -1 ) {
		if( !didcomplain ) {
			perror( "UDPMessageSocket::send(): sendto() failed" );
			didcomplain = true;
		}
		return -1;
	}
	return 0;
}


int UDPMessageSocket::receive( char *recvbuffer, unsigned int maxlength )
{
	socklen_t addrlength;
	int numbytes;
	addrlength = sizeof( struct sockaddr );
	if ( ( numbytes = recvfrom( socketfd, recvbuffer, maxlength, 0, \
			(struct sockaddr *) &remoteaddress, &addrlength ) ) == -1 ) {
		perror( "UDPMessageSocket::recieve(): recvfrom() failed" );
		return -1;
	}
	return numbytes;
}


unsigned int UDPMessageSocket::listen( unsigned int portnum )
{
	struct sockaddr name;
	socklen_t namesize;
	socketaddress.sin_family = AF_INET;
	socketaddress.sin_port = htons( portnum );
	socketaddress.sin_addr.s_addr = INADDR_ANY;
	bzero( &(socketaddress.sin_zero), 8 ); // is this portable?

	int count = 0;
	while ( bind( socketfd, (struct sockaddr *) &socketaddress, sizeof( struct sockaddr) ) == -1  && count <= 10 ) {
		count++;
		portnum += 2;
		socketaddress.sin_port = htons( portnum );
	}
	if ( count > 10 ) {
		perror( "UDPMessageSocket::listen(): bind() failed" );
		return 0;
	}
	namesize = sizeof( struct sockaddr );
	bzero( &name, sizeof( struct sockaddr ) );
	if ( getsockname( socketfd, &name, &namesize ) == -1 ) {
		perror( "UDPMessageSocket::listen(): getsockname() failed" );
		return 0;
	}
	ourport = ntohs( ((struct sockaddr_in *) &name)->sin_port );
	return ourport;
}


int UDPMessageSocket::listenOnEvenPort( void )
{
	struct sockaddr name;
	socklen_t namesize;
	int oldsocketfd = 0;
	int portnum = 0;

getaddress:
	socketaddress.sin_family = AF_INET;
	socketaddress.sin_port = htons( portnum );
	socketaddress.sin_addr.s_addr = INADDR_ANY;
	bzero( &(socketaddress.sin_zero), 8 ); // is this portable?
	if ( bind( socketfd, (struct sockaddr *) &socketaddress, sizeof( struct sockaddr) ) == -1 ) {
		perror( "UDPMessageSocket::listen(): bind() failed" );
		return -1;
	}
	namesize = sizeof( struct sockaddr );
	bzero( &name, sizeof( struct sockaddr ) );
	if ( getsockname( socketfd, &name, &namesize ) == -1 ) {
		perror( "UDPMessageSocket::listen(): getsockname() failed" );
		return -1;
	}
	ourport = ntohs( ((struct sockaddr_in *) &name)->sin_port );
	printf( "UDPMessageSocket: Listening on %d\n", ourport );
	if( ( portnum == 0 ) && ( ourport % 2 ) != 0 ) {
		printf( "UDPMessageSocket: Retrying...\n" );
		oldsocketfd = socketfd;
		if( ( socketfd = socket( AF_INET, SOCK_DGRAM, 0 ) ) == -1 ) {
			perror( "UDPMessageSocket::UDPMessageSocket(): socket() failed" );
		}
		goto getaddress;
	}
	if( oldsocketfd != 0 )
		close( oldsocketfd );
	return 0;
}


int UDPMessageSocket::listenOnEvenPortForVideo( void )
{
	struct sockaddr name;
	socklen_t namesize;
	int oldsocketfd = 0;
	int portnum = 0;

	if ( ( socketfd = socket( AF_INET, SOCK_DGRAM, 0 ) ) == -1 ) {
		perror( "UDPMessageSocket::UDPMessageSocket(): socket() failed" );
	}

getaddress:
	socketaddress.sin_family = AF_INET;
	socketaddress.sin_port = htons( portnum );
	socketaddress.sin_addr.s_addr = INADDR_ANY;
	bzero( &(socketaddress.sin_zero), 8 ); // is this portable?

	int one = 1;
	if ( setsockopt( socketfd, SOL_SOCKET, SO_REUSEADDR, &one, sizeof( one ) ) == -1 ) {
		perror( "UDPMessageSocket::setsockopt SO_REUSEADDR" );
	}

	if ( bind( socketfd, (struct sockaddr *) &socketaddress, sizeof( struct sockaddr) ) == -1 ) {
		perror( "UDPMessageSocket::listen(): bind() failed" );
		return -1;
	}

	namesize = sizeof( struct sockaddr );
	bzero( &name, sizeof( struct sockaddr ) );
	if ( getsockname( socketfd, &name, &namesize ) == -1 ) {
		perror( "UDPMessageSocket::listen(): getsockname() failed" );
		return -1;
	}
	ourport = ntohs( ((struct sockaddr_in *) &name)->sin_port );
	printf( "UDPMessageSocket (video): Listening on %d\n", ourport );
	if( portnum == 0 && ( ourport % 4 ) != 0 ) {
		printf( "UDPMessageSocket: Retrying...\n" );
		oldsocketfd = socketfd;
		if( ( socketfd = socket( AF_INET, SOCK_DGRAM, 0 ) ) == -1 ) {
			perror( "UDPMessageSocket::UDPMessageSocket(): socket() failed" );
		}
		goto getaddress;
	}
	if( oldsocketfd != 0 )
		close( oldsocketfd );

	return 0;
}


int UDPMessageSocket::accept( void )
{
	return socketfd;
}

